package cn.ipokerface.web.controller;

import cn.ipokerface.common.model.api.ResultBody;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by       mac
 * Create Date      2020/12/11
 * Version          1.0.0
 * Description:
 */


@RestController
@RequestMapping
@AutoConfigureBefore(ErrorMvcAutoConfiguration.class)
public class HandlerController extends BaseController implements ErrorController {

    public static final String ERROR_PATH = "/error";

    public static final String ERROR_STATUS = "javax.servlet.error.status_code";


    @RequestMapping(value = ERROR_PATH)
    public ResultBody error(HttpServletRequest request, HttpServletResponse response) {

        Object statusObject = request.getAttribute(ERROR_STATUS);
        if (statusObject == null)
            return ResultBody.error();
        try{
            int statusCode = Integer.parseInt(statusObject.toString());
            switch (statusCode) {
                case 404:
                    return ResultBody.error(ResultBody.Result.ERROR_NOT_FOUND.getCode(), ResultBody.Result.ERROR_NOT_FOUND.getMsg());
                default:
                    return ResultBody.error(ResultBody.Result.ERROR.getCode(),ResultBody.Result.ERROR.getMsg());
            }
        }catch (Exception e) {
            e.printStackTrace();
            // 非法的code
            return ResultBody.error(ResultBody.Result.ERROR.getCode(),ResultBody.Result.ERROR.getMsg());
        }

    }


    @Override
    public String getErrorPath() {
        return ERROR_PATH;
    }
}
