package cn.ipokerface.web.spring;


import cn.ipokerface.common.fastjson.filters.NullValueFilter;
import cn.ipokerface.common.utils.StringUtils;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;

/**
 * Created by       PokerFace
 * Create Date      2019-10-22.
 * Email:
 * <p>
 * Description:     Use this filter to wrapper request so that request's inputstream could be use any times.
 *                  so you should set config <code>spring.mvc.filter.request-wrapper.enable = true</code>
 *                  more:
 *                  <code>spring.mvc.filter.request-wrapper.filter-path = /path/to/filter</code> default<code>/api/*</code>
 *
 */

@Configuration
@EnableConfigurationProperties({ WebConvertersProperties.class})
public class WebAutoConfiguration {


    /**
     *  Auto config fastjson mvc cofiguration
     *  set<code>spring.mvc.fast-json.converters-enable=true</code>
     *  set<code>spring.mvc.fast-json.features=PrettyFormat,QuoteFieldNames,...</code>{@link SerializerFeature}
     *
     * @param mvcConvertersProperties properties
     *
     * @return {@link HttpMessageConverter}
     */
    @Bean
    @ConditionalOnProperty(value = "spring.web.converters.fast-json-enabled", havingValue = "true")
    @ConditionalOnMissingBean(HttpMessageConverters.class)
    public HttpMessageConverters fastJsonHttpMessageConverters(WebConvertersProperties mvcConvertersProperties) {
        FastJsonHttpMessageConverter fastConvert = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();

        //
        SerializeConfig serializeConfig = fastJsonConfig.getSerializeConfig();
        fastJsonConfig.setSerializeConfig(serializeConfig);

        if (StringUtils.isNotBlank(mvcConvertersProperties.getFastJsonFeatures())){
            String[] featuresArray = mvcConvertersProperties.getFastJsonFeatures().split(",");
            SerializerFeature[] features = new SerializerFeature[featuresArray.length];
            for(int i=0;i<featuresArray.length; i++) {
                SerializerFeature feature = SerializerFeature.valueOf(featuresArray[i]);
                features[i] = feature;
            }
            fastJsonConfig.setSerializerFeatures(features);
        }
        // 把 null 对象输出为 ""
        fastJsonConfig.setSerializeFilters(new NullValueFilter());
        fastJsonConfig.setDateFormat(mvcConvertersProperties.getDatetimeFormatter());
        fastConvert.setFastJsonConfig(fastJsonConfig);
        return new HttpMessageConverters(fastConvert);
    }

}
