package cn.ipokerface.web.controller;

import cn.ipokerface.common.http.Header;
import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.common.model.BaseModel;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.common.utils.FileUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;

/**
 * Created by       PokerFace
 * Create Date      2019-11-23.
 * Email:           
 * Version          1.0.0
 * <p>
 * Description:     some api to operate request and response
 *                  All controller should extend this {@link BaseController}
 */


public abstract class BaseController extends LoggerAdapter {


    /**
     *  Get client real ip address .
     *  Header of client ip is {@link Header#X_FORWARDED_FOR_HEADER}
     *  and this header may rewrite by gateway service such as <code>nignx</code>
     *
     * @param request tomcat request
     * @return real ip address of client
     */
    protected String getClientIpAddress(HttpServletRequest request){

        String ip = "";
        try {
            ip = request.getHeader("x-forwarded-for");
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
                if (ip.equals("127.0.0.1") || ip.equals("0:0:0:0:0:0:0:1")) {
                    try {
                        InetAddress inet = InetAddress.getLocalHost();
                        ip = inet.getHostAddress();
                    } catch (UnknownHostException e) {
                    }
                }
            }
            return ip.split(",")[0];
        } catch (Exception e) {
        }
        return ip;
    }


    /**
     *  write file to response
     *
     * @param response httpResponse
     * @param filePath file path of file
     * @throws IOException exception io
     */
    protected void writeFile(HttpServletResponse response, String filePath) throws IOException {
        File file = new File(filePath);

        if (file == null || !file.exists()) return;
        writeFile(response, new FileInputStream(file), file.getName());

    }


    /**
     *  Write file of inputStream to outputStream
     *
     * @param response httpResponse
     * @param inputStream inputStream
     * @param filename file name just name
     * @throws IOException exception io
     */
    protected void writeFile(HttpServletResponse response, InputStream inputStream, String filename) throws IOException{
        String outFile = URLEncoder.encode(filename, "UTF-8");

        response.setCharacterEncoding("UTF-8");
        response.setHeader(Header.CONTENT_TYPE, "application/vnd.ms-excel");
        response.setHeader(Header.CONTENT_DISPOSITION, "attachment;filename="+ outFile);
        response.addHeader(Header.CACHE_CONTROL, "no-cache");

        FileUtils.writeTo(inputStream, response.getOutputStream());
    }


    /**
     *  success response
     *
     * @param model response body
     * @return  response entity
     */
    protected ResultBody success(BaseModel model) {
        return ResultBody.builder().data(model).build();
    }


    protected ResultBody success() {
        return ResultBody.builder().build();
    }
}
