/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.spring;

import cn.ipokerface.common.fastjson.filters.NullValueFilter;
import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.web.spring.WebConvertersProperties;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration
@EnableConfigurationProperties(value={WebConvertersProperties.class})
public class WebAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"spring.web.converters.fast-json-enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={HttpMessageConverters.class})
    public HttpMessageConverters fastJsonHttpMessageConverters(WebConvertersProperties mvcConvertersProperties) {
        FastJsonHttpMessageConverter fastConvert = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        SerializeConfig serializeConfig = fastJsonConfig.getSerializeConfig();
        fastJsonConfig.setSerializeConfig(serializeConfig);
        if (StringUtils.hasText((String)mvcConvertersProperties.getFastJsonFeatures())) {
            String[] featuresArray = mvcConvertersProperties.getFastJsonFeatures().split(",");
            SerializerFeature[] features = new SerializerFeature[featuresArray.length];
            for (int i = 0; i < featuresArray.length; ++i) {
                SerializerFeature feature;
                features[i] = feature = SerializerFeature.valueOf((String)featuresArray[i]);
            }
            fastJsonConfig.setSerializerFeatures(features);
        }
        fastJsonConfig.setSerializeFilters(new SerializeFilter[]{new NullValueFilter()});
        fastJsonConfig.setDateFormat(mvcConvertersProperties.getDatetimeFormatter());
        fastConvert.setFastJsonConfig(fastJsonConfig);
        return new HttpMessageConverters(new HttpMessageConverter[]{fastConvert});
    }
}

