package cn.ipokerface.web.controller;

import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.common.model.api.ResultBody;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * Created by       mac
 * Create Date      2020/12/11
 * Version          1.0.0
 * Description:
 */


@Order(Integer.MAX_VALUE)
@Configuration
@ControllerAdvice
public class ControllerExceptionHandler extends LoggerAdapter {

    @ResponseBody
    @ExceptionHandler(value = Exception.class)
    public ResultBody exceptionHandler(Exception ex) {
        ResultBody.Builder builder = ResultBody.builder();

        if (ex instanceof NumberFormatException) {
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), ex.getMessage());
        }
        else if (ex instanceof IllegalArgumentException || ex instanceof EnumConstantNotPresentException) {
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), ex.getMessage());
        }
        else if (ex instanceof MissingServletRequestParameterException) {
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), ex.getMessage());
        }
        else if (ex instanceof HttpRequestMethodNotSupportedException) {
            builder.error(ResultBody.Result.ERROR_METHOD.getCode(), ex.getMessage());
        }
        else if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException) ex;
            exception.getBindingResult().getFieldError().getDefaultMessage();
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(),exception.getBindingResult().getFieldError().getDefaultMessage());
        }
        else {
            builder.error(ResultBody.Result.ERROR.getCode(), ResultBody.Result.ERROR.getMsg());
        }

        // 输出ex日志
        error(ex);

        return builder.build();
    }
}
