/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.controller;

import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.web.controller.BaseController;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
public class HandlerController
extends BaseController
implements ErrorController {
    public static final String ERROR_PATH = "/error";
    public static final String ERROR_STATUS = "javax.servlet.error.status_code";

    @RequestMapping(value={"/error"})
    public ResultBody error(HttpServletRequest request, HttpServletResponse response) {
        ResultBody.Builder builder = ResultBody.builder();
        Object statusObject = request.getAttribute(ERROR_STATUS);
        if (statusObject == null) {
            return builder.build();
        }
        try {
            int statusCode = Integer.parseInt(statusObject.toString());
            switch (statusCode) {
                case 404: {
                    builder.error(ResultBody.Result.ERROR_NOT_FOUND.getCode(), ResultBody.Result.ERROR_NOT_FOUND.getMsg());
                    break;
                }
                default: {
                    builder.error(ResultBody.Result.ERROR.getCode(), ResultBody.Result.ERROR.getMsg());
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            builder.error(ResultBody.Result.ERROR.getCode(), ResultBody.Result.ERROR.getMsg());
        }
        return builder.build();
    }

    public String getErrorPath() {
        return ERROR_PATH;
    }
}

