/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.controller;

import cn.ipokerface.common.logback.LoggerAdapter;
import cn.ipokerface.common.model.api.ResultBody;
import cn.ipokerface.web.exception.ServiceResultException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

@Configuration
@ControllerAdvice
public class ControllerExceptionHandler
extends LoggerAdapter {
    private Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);

    @ResponseBody
    @ExceptionHandler(value={Exception.class})
    public ResultBody exceptionHandler(Exception ex) {
        ResultBody.Builder builder = ResultBody.builder();
        if (ex instanceof NumberFormatException) {
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), ex.getMessage());
        } else if (ex instanceof IllegalArgumentException || ex instanceof EnumConstantNotPresentException) {
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), ex.getMessage());
        } else if (ex instanceof MissingServletRequestParameterException) {
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), ex.getMessage());
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            builder.error(ResultBody.Result.ERROR_METHOD.getCode(), ex.getMessage());
        } else if (ex instanceof MethodArgumentNotValidException) {
            MethodArgumentNotValidException exception = (MethodArgumentNotValidException)ex;
            exception.getBindingResult().getFieldError().getDefaultMessage();
            builder.error(ResultBody.Result.ERROR_ARGUMENT.getCode(), exception.getBindingResult().getFieldError().getDefaultMessage());
        } else if (ex instanceof ServiceResultException) {
            builder.error(((ServiceResultException)((Object)ex)).getCode(), ex.getMessage());
        } else {
            builder.error(ResultBody.Result.ERROR.getCode(), ex.getMessage());
        }
        this.error(ex);
        return builder.build();
    }
}

