/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.web.controller;

import cn.ipokerface.common.utils.FileUtils;
import cn.ipokerface.common.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseController {
    protected String getClientIpAddress(HttpServletRequest request) {
        String forwardedFor = request.getHeader("X-Forwarded-For");
        if (StringUtils.isEmpty((Object)forwardedFor)) {
            return request.getRemoteAddr();
        }
        String[] addresses = forwardedFor.split(",");
        if (addresses != null && addresses.length > 0) {
            return addresses[0];
        }
        return forwardedFor;
    }

    protected void writeFile(HttpServletResponse response, String filePath) throws IOException {
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            return;
        }
        this.writeFile(response, new FileInputStream(file), file.getName());
    }

    protected void writeFile(HttpServletResponse response, InputStream inputStream, String filename) throws IOException {
        String outFile = new String(filename.getBytes(), Charset.forName("ISO8859-1"));
        response.setContentType("application/octet-stream;charset=ISO8859-1");
        response.setHeader("Content-Disposition", "attachment;filename=" + outFile);
        response.addHeader("Cache-Control", "no-cache");
        FileUtils.writeTo((InputStream)inputStream, (OutputStream)response.getOutputStream());
    }
}

