package cn.ipokerface.web.api;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Created by       PokerFace
 * Create Date      2020-11-12.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:     使用：
 *                      注解在Controller 的方法上
 *                      <code>@RequireSignature(['param1','param2']);</code>
 *                      注意 程序会按照注解参数的顺序拼接参数进行较验
 *                      md5加密转换成小写
 */

@Target({ElementType.METHOD})
@Retention(RUNTIME)
@Documented
public @interface RequireSignature {


    /**
     *  Use to Controllers request method to point witch params is required
     *
     * @return string parameters.
     */
    String[] parameters();



}
