package cn.ipokerface.common.encrypt;

import cn.ipokerface.common.digest.FakeEncrypt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by       PokerFace
 * Create Date      2021/6/9.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration
@ConditionalOnProperty(value = "spring.encrypt.fake.enabled", havingValue = "true", matchIfMissing = false)
@EnableConfigurationProperties({FakeEncryptProperties.class})
public class FakeEncryptAutoConfiguration {


    @Autowired
    private FakeEncryptProperties fakeEncryptProperties;


    @Bean
    public FakeEncrypt fakeEncrypt() {
        return new FakeEncrypt(fakeEncryptProperties.getSecret());
    }

}
