package cn.ipokerface.common.encrypt;

import cn.ipokerface.common.digest.RsaEncrypt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by       PokerFace
 * Create Date      2021/6/9.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration
@EnableConfigurationProperties({RsaEncryptProperties.class})
@ConditionalOnProperty(value = "spring.encrypt.rsa.enabled", havingValue = "true", matchIfMissing = false)
public class RsaEncryptAutoConfiguration {


    @Autowired
    private RsaEncryptProperties rsaEncryptProperties;


    @Bean
    public RsaEncrypt rsaEncrypt() {
        return new RsaEncrypt(rsaEncryptProperties.getPrivateKey(), rsaEncryptProperties.getPublicKey());
    }

}
