package cn.ipokerface.common.encrypt;

import cn.ipokerface.common.digest.AesEncrypt;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by       PokerFace
 * Create Date      2021/6/9.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
@EnableConfigurationProperties({AesEncryptProperties.class})
@ConditionalOnProperty(value = "spring.encrypt.aes.enabled", havingValue = "true", matchIfMissing = false)
@Configuration
public class AesEncryptAutoConfiguration {


    @Autowired
    private AesEncryptProperties aesEncryptProperties;


    @Bean
    public AesEncrypt aesEncrypt() {
        return new AesEncrypt(aesEncryptProperties.getKey(), aesEncryptProperties.getIv());
    }



}
