package cn.ipokerface.common.async;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

/**
 * Created by       PokerFace
 * Create Date      2020-11-08.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration
@ConfigurationProperties(prefix = "spring.async")
public class ThreadPoolProperties {


    /**
     *  Enable ThreadPoolExecutor or not
     *
     */
    private boolean enabled = false;

    /**
     * TimeUnit of this threadPoolExecutor thread...
     * {@link TimeUnit}
     * TimeUnti.MILLISECONDS
     *
     */
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;


    /**
     * Queue type of threadPool manager..
     *
     *  ArrayBlockingQueue;
     *  LinkedBlockingQueue;
     *  SynchronousQueue;
     *
     */
    private String queueType = "LinkedBlockingDeque";


    /**
     *  when use arrayBlockingQueue    capacity
     *
     */
    private int ArrayBlockingQueueCapacity = 100000;

    /**
     * Handler policy
     *  {@link java.util.concurrent.ThreadPoolExecutor.DiscardPolicy}
     *  {@link java.util.concurrent.ThreadPoolExecutor.AbortPolicy}
     *  {@link java.util.concurrent.ThreadPoolExecutor.DiscardOldestPolicy}
     *  ...
     *
     */
    private String handlerPolicy = "DiscardPolicy";


    /**
     * core pool size of this pool.
     * recommend to be times of heart of CPU core.
     *
     */
    private int corePoolSize = 4;


    /**
     *  maximumSize
     *
     */
    private int maximumPoolSize = 8;


    /**
     *  keep alive time after task..
     *  {@link #timeUnit}
     *
     */
    private long keepAliveTime = 60000L;


    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public TimeUnit getTimeUnit() {
        return timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getQueueType() {
        return queueType;
    }

    public void setQueueType(String queueType) {
        this.queueType = queueType;
    }

    public int getArrayBlockingQueueCapacity() {
        return ArrayBlockingQueueCapacity;
    }

    public void setArrayBlockingQueueCapacity(int arrayBlockingQueueCapacity) {
        ArrayBlockingQueueCapacity = arrayBlockingQueueCapacity;
    }

    public String getHandlerPolicy() {
        return handlerPolicy;
    }

    public void setHandlerPolicy(String handlerPolicy) {
        this.handlerPolicy = handlerPolicy;
    }

    public int getCorePoolSize() {
        return corePoolSize;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public int getMaximumPoolSize() {
        return maximumPoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public long getKeepAliveTime() {
        return keepAliveTime;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }
}
