/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.cloud.config.spring;

import cn.ipokerface.cloud.config.repository.LocalEnvironmentRepositoryFactory;
import cn.ipokerface.cloud.config.spring.LocalRepositoryConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@AutoConfigureBefore(value={LocalRepositoryConfiguration.class})
public class LocalRepositoryFactoryConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={NativeEnvironmentRepositoryFactory.class})
    @ConditionalOnProperty(value={"spring.cloud.config.server.native.local"}, matchIfMissing=true)
    public LocalEnvironmentRepositoryFactory customNativeEnvironmentRepositoryFactory(ConfigurableEnvironment environment, ConfigServerProperties properties) {
        return new LocalEnvironmentRepositoryFactory(environment, properties);
    }
}

