/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.cloud.config.repository;

import cn.ipokerface.cloud.config.repository.LocalEnvironmentProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.context.PropertyPlaceholderAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.config.ConfigFileApplicationListener;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.PassthruEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

public class LocalEnvironmentRepository
implements EnvironmentRepository,
SearchPathLocator,
Ordered {
    private Logger logger = LoggerFactory.getLogger(LocalEnvironmentRepository.class);
    private static final String[] DEFAULT_LOCATIONS = new String[]{"classpath:/", "classpath:/config/", "file:./", "file:./config/"};
    private ConfigurableEnvironment environment;
    private int order;
    private String version;
    private String[] searchLocations;

    public LocalEnvironmentRepository(ConfigurableEnvironment environment, LocalEnvironmentProperties properties) {
        this.environment = environment;
        this.order = properties.getOrder();
        this.searchLocations = properties.getSearchLocations();
        this.version = properties.getVersion();
    }

    public Environment findOne(String config, String profile, String label, boolean includeOrigin) {
        return this.findOne(config, profile, label);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment findOne(String config, String profile, String label) {
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Class[]{PropertyPlaceholderAutoConfiguration.class});
        ConfigurableEnvironment environment = this.getEnvironment(profile);
        builder.environment(environment);
        builder.web(WebApplicationType.NONE).bannerMode(Banner.Mode.OFF);
        if (!this.logger.isDebugEnabled()) {
            builder.logStartupInfo(false);
        }
        String[] args = this.getArgs(config, profile, label);
        builder.application().setListeners(Arrays.asList(new ConfigFileApplicationListener()));
        ConfigurableApplicationContext context = builder.run(args);
        environment.getPropertySources().remove("profiles");
        try {
            Environment environment2 = this.clean(new PassthruEnvironmentRepository(environment).findOne(config, profile, label));
            return environment2;
        }
        finally {
            context.close();
        }
    }

    private String[] getArgs(String application, String profile, String label) {
        ArrayList<String> list = new ArrayList<String>();
        String config = application;
        if (!StringUtils.isEmpty((Object)label) && !label.equals(application)) {
            config = label;
        }
        list.add("--spring.config.name=" + config);
        list.add("--spring.cloud.bootstrap.enabled=false");
        list.add("--encrypt.failOnError=false");
        list.add("--spring.config.location=" + StringUtils.arrayToCommaDelimitedString((Object[])this.getLocations(application, profile, label).getLocations()));
        return list.toArray(new String[0]);
    }

    private ConfigurableEnvironment getEnvironment(String profile) {
        StandardEnvironment environment = new StandardEnvironment();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spring.profiles.active", profile);
        map.put("spring.main.web-application-type", "none");
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("profiles", map));
        return environment;
    }

    protected Environment clean(Environment value) {
        Environment result = new Environment(value.getName(), value.getProfiles(), value.getLabel(), this.getVersion(), value.getState());
        String profile = result.getProfiles() == null ? null : StringUtils.arrayToCommaDelimitedString((Object[])result.getProfiles());
        SearchPathLocator.Locations locations = this.getLocations(result.getName(), profile, result.getLabel());
        for (org.springframework.cloud.config.environment.PropertySource source : value.getPropertySources()) {
            String name = source.getName();
            if (this.environment.getPropertySources().contains(name)) continue;
            name = name.replace("applicationConfig: [", "");
            name = name.replace("]", "");
            if (this.getSearchLocations() != null) {
                boolean matches = false;
                String normal = name;
                if (normal.startsWith("file:")) {
                    normal = StringUtils.cleanPath((String)new File(normal.substring("file:".length())).getAbsolutePath());
                }
                for (String pattern : locations.getLocations()) {
                    if (!pattern.contains(":")) {
                        pattern = "file:" + pattern;
                    }
                    if (pattern.startsWith("file:")) {
                        pattern = StringUtils.cleanPath((String)new File(pattern.substring("file:".length())).getAbsolutePath()) + "/";
                    }
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Testing pattern: " + pattern + " with property source: " + name);
                    }
                    if (!normal.startsWith(pattern) || normal.substring(pattern.length()).contains("/")) continue;
                    matches = true;
                    break;
                }
                if (!matches) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Not adding property source: " + name);
                    continue;
                }
            }
            this.logger.info("Adding property source: " + name);
            result.add(new org.springframework.cloud.config.environment.PropertySource(name, source.getSource()));
        }
        return result;
    }

    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        String[] locations = this.getSearchLocations();
        if (this.getSearchLocations() == null || this.getSearchLocations().length == 0 || StringUtils.isEmpty((Object)label)) {
            locations = DEFAULT_LOCATIONS;
        }
        LinkedHashSet<String> output = new LinkedHashSet<String>();
        for (String location : locations) {
            String[] profiles = new String[]{profile};
            if (profile != null) {
                profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            }
            String[] apps = new String[]{application};
            if (application != null) {
                apps = StringUtils.commaDelimitedListToStringArray((String)application);
            }
            for (String prof : profiles) {
                for (String app : apps) {
                    String value = location;
                    if (application != null) {
                        value = value.replace("{application}", app);
                    }
                    if (prof != null) {
                        value = value.replace("{profile}", prof);
                    }
                    if (label != null) {
                        value = value.replace("{label}", label);
                    }
                    if (!value.endsWith("/")) {
                        value = value + "/";
                    }
                    if (!this.isDirectory(value)) continue;
                    output.add(value);
                }
            }
        }
        return new SearchPathLocator.Locations(application, profile, label, this.getVersion(), output.toArray(new String[0]));
    }

    private boolean isDirectory(String location) {
        return !location.contains("{") && !location.endsWith(".properties") && !location.endsWith(".yml") && !location.endsWith(".yaml");
    }

    public String getVersion() {
        return this.version;
    }

    public String[] getSearchLocations() {
        return this.searchLocations;
    }

    public void setSearchLocations(String ... locations) {
        this.searchLocations = locations;
        if (locations != null) {
            for (int i = 0; i < locations.length; ++i) {
                String location = locations[i];
                if (this.isDirectory(location) && !location.endsWith("/")) {
                    location = location + "/";
                }
                locations[i] = location;
            }
        }
    }

    public int getOrder() {
        return this.order;
    }
}

