package cn.ipokerface.cloud.config.spring;

import cn.ipokerface.cloud.config.repository.LocalEnvironmentRepositoryFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.NativeEnvironmentRepositoryFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * Created by       PokerFace
 * Create Date      2020-06-19.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration
@AutoConfigureBefore({
        LocalRepositoryConfiguration.class
})
public class LocalRepositoryFactoryConfiguration {



    @Bean
    @ConditionalOnMissingBean(NativeEnvironmentRepositoryFactory.class)
    @ConditionalOnProperty(value = "spring.cloud.config.server.native.local", matchIfMissing = true)
    public LocalEnvironmentRepositoryFactory customNativeEnvironmentRepositoryFactory(ConfigurableEnvironment environment,
                                                                                      ConfigServerProperties properties) {
        return new LocalEnvironmentRepositoryFactory(environment, properties);
    }
}
