package cn.ipokerface.cloud.config.spring;

import cn.ipokerface.cloud.config.repository.LocalEnvironmentProperties;
import cn.ipokerface.cloud.config.repository.LocalEnvironmentRepository;
import cn.ipokerface.cloud.config.repository.LocalEnvironmentRepositoryFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.EnvironmentRepositoryConfiguration;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by       PokerFace
 * Create Date      2020-06-19.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration
@AutoConfigureBefore({
        EnvironmentRepositoryConfiguration.class
})
@EnableConfigurationProperties({LocalEnvironmentProperties.class})
public class LocalRepositoryConfiguration {

    public static final String ENABLE_CUSTOM_REPOSITORY = "spring.cloud.config.server.native.local";


    @Bean
    @ConditionalOnMissingBean(LocalEnvironmentRepository.class)
    @ConditionalOnProperty(value = ENABLE_CUSTOM_REPOSITORY, matchIfMissing = true)
    public LocalEnvironmentRepository nativeEnvironmentRepository(LocalEnvironmentRepositoryFactory factory,
                                                                  LocalEnvironmentProperties environmentProperties) {
        return factory.build(environmentProperties);
    }

}
