package cn.ipokerface.cloud.config.repository;

import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.EnvironmentRepositoryFactory;
import org.springframework.cloud.config.server.environment.NativeEnvironmentProperties;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * Created by       PokerFace
 * Create Date      2020-06-19.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class LocalEnvironmentRepositoryFactory implements EnvironmentRepositoryFactory<LocalEnvironmentRepository,
        LocalEnvironmentProperties> {

    private ConfigurableEnvironment environment;
    private ConfigServerProperties properties;

    public LocalEnvironmentRepositoryFactory(
            ConfigurableEnvironment environment, ConfigServerProperties properties) {
        this.environment = environment;
        this.properties = properties;
    }


    @Override
    public LocalEnvironmentRepository build(
            LocalEnvironmentProperties environmentProperties) {
        LocalEnvironmentRepository repository =
                new LocalEnvironmentRepository(environment, environmentProperties);

        return repository;
    }
}