package cn.ipokerface.cloud.config.repository;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.config.server.support.EnvironmentRepositoryProperties;
import org.springframework.core.Ordered;

/**
 * Created by       PokerFace
 * Create Date      2020-08-02.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */



@ConfigurationProperties("spring.cloud.config.server.native")
public class LocalEnvironmentProperties implements EnvironmentRepositoryProperties {


    /**
     *
     *
     */
    private String[] searchLocations = new String[0];


    /**
     *  定义是否在路径的基础上使用环境来区分不同文件夹
     *
     */
    private boolean profileBase = true;


    private String version;

    private int order = Ordered.LOWEST_PRECEDENCE;



    public String[] getSearchLocations() {
        return searchLocations;
    }

    public void setSearchLocations(String[] searchLocations) {
        this.searchLocations = searchLocations;
    }


    public boolean isProfileBase() {
        return profileBase;
    }

    public void setProfileBase(boolean profileBase) {
        this.profileBase = profileBase;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}
