package cn.ipokerface.cloud.config.spring;

import cn.ipokerface.cloud.config.source.ConfigServicePropertySourceLocator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.client.ConfigClientProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;

/**
 * Created by       PokerFace
 * Create Date      2020-06-19.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Configuration()
public class ConfigServiceClientBootstrapConfiguration {

    @Autowired
    private ConfigurableEnvironment environment;




    @Bean
    @ConditionalOnMissingBean(org.springframework.cloud.config.client.ConfigServicePropertySourceLocator.class)
    @ConditionalOnProperty(value = "spring.cloud.config.local", matchIfMissing = true)
    public ConfigServicePropertySourceLocator configServicePropertySourceLocator(ConfigClientProperties configClientProperties) {
        ConfigServicePropertySourceLocator locator = new ConfigServicePropertySourceLocator(
                configClientProperties);
        return locator;
    }

}
