/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.common.async;

import cn.ipokerface.common.async.ThreadPoolProperties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"spring.async.enabled"}, matchIfMissing=false)
@EnableConfigurationProperties(value={ThreadPoolProperties.class})
public class ThreadPoolAutoConfiguration {
    @Autowired
    ThreadPoolProperties threadPoolProperties;

    @Bean
    public ThreadPoolExecutor threadPoolExecutor() {
        TimeUnit timeUnit = this.threadPoolProperties.getTimeUnit();
        LinkedBlockingDeque<Runnable> taskQueue = null;
        switch (this.threadPoolProperties.getQueueType()) {
            case "LinkedBlockingDeque": {
                taskQueue = new LinkedBlockingDeque();
                break;
            }
            case "ArrayBlockingQueue": {
                taskQueue = new ArrayBlockingQueue(this.threadPoolProperties.getArrayBlockingQueueCapacity());
                break;
            }
            case "SynchronousQueue": {
                taskQueue = new SynchronousQueue();
            }
        }
        RejectedExecutionHandler handler = null;
        switch (this.threadPoolProperties.getHandlerPolicy()) {
            case "DiscardPolicy": {
                handler = new ThreadPoolExecutor.DiscardPolicy();
                break;
            }
            case "AbortPolicy": {
                handler = new ThreadPoolExecutor.AbortPolicy();
                break;
            }
            case "CallerRunsPolicy": {
                handler = new ThreadPoolExecutor.CallerRunsPolicy();
                break;
            }
            case "DiscardOldestPolicy": {
                handler = new ThreadPoolExecutor.DiscardOldestPolicy();
            }
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.threadPoolProperties.getCorePoolSize(), this.threadPoolProperties.getMaximumPoolSize(), this.threadPoolProperties.getKeepAliveTime(), timeUnit, taskQueue, handler);
        threadPoolExecutor.prestartCoreThread();
        return threadPoolExecutor;
    }
}

