/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.snowflake;

import cn.ipokerface.redis.spring.JedisAutoConfiguration;
import cn.ipokerface.snowflake.SnowflakeCacheService;
import cn.ipokerface.snowflake.SnowflakeCacheServiceJedisCluster;
import cn.ipokerface.snowflake.SnowflakeCacheServiceJedisStandalone;
import cn.ipokerface.snowflake.SnowflakeIdGenerator;
import cn.ipokerface.snowflake.SnowflakeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

@Configuration
@EnableConfigurationProperties(value={SnowflakeProperties.class})
@AutoConfigureAfter(value={JedisAutoConfiguration.class})
@ConditionalOnProperty(name={"spring.snowflake.enabled"}, havingValue="true", matchIfMissing=false)
public class SnowflakeRedisAutoConfiguration {
    @Autowired
    private SnowflakeProperties snowflakeProperties;

    @Primary
    @Bean
    @ConditionalOnProperty(value={"spring.redis.mode"}, havingValue="standalone", matchIfMissing=true)
    public SnowflakeCacheService snowflakeCacheServiceJedisStandalone(JedisPool jedisPool) {
        return new SnowflakeCacheServiceJedisStandalone(jedisPool);
    }

    @Primary
    @Bean
    @ConditionalOnProperty(value={"spring.redis.mode"}, havingValue="cluster", matchIfMissing=false)
    public SnowflakeCacheService snowflakeCacheServiceJedisCluster(JedisCluster jedisCluster) {
        return new SnowflakeCacheServiceJedisCluster(jedisCluster);
    }

    @Primary
    @Bean
    public SnowflakeIdGenerator snowflakeIdGenerator(final SnowflakeCacheService snowflakeCacheService) {
        int workerId = -1;
        for (int i = 0; i < 1024; ++i) {
            String key = this.snowflakeProperties.getCacheKey() + "DATACENTER_" + this.snowflakeProperties.getDatacenterId() + ":WORKER_" + i;
            String result = snowflakeCacheService.setNX(key, "SNOWFLAKE");
            Long ttl = snowflakeCacheService.ttl(key);
            if ((StringUtils.isEmpty((Object)result) || !"OK".equals(result)) && ttl != null && ttl > 0L) continue;
            workerId = i;
            break;
        }
        final String key = this.snowflakeProperties.getCacheKey() + "DATACENTER_" + this.snowflakeProperties.getDatacenterId() + ":WORKER_" + workerId;
        if (workerId == -1) {
            throw new IllegalStateException("Woker instance has more than volume of 32 ");
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    snowflakeCacheService.expire(key, 7);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }.start();
        if (this.snowflakeProperties.getEpochTimestamp() <= 0L) {
            return new SnowflakeIdGenerator((long)workerId, this.snowflakeProperties.getDatacenterId());
        }
        return new SnowflakeIdGenerator((long)workerId, this.snowflakeProperties.getDatacenterId(), this.snowflakeProperties.getEpochTimestamp());
    }
}

