package cn.ipokerface.snowflake;

import cn.ipokerface.redis.spring.JedisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;

/**
 * Created by       PokerFace
 * Create Date      2021/4/7.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */



@Configuration
@EnableConfigurationProperties({SnowflakeProperties.class})
@AutoConfigureAfter(JedisAutoConfiguration.class)
@ConditionalOnProperty(name = "spring.snowflake.enabled", havingValue = "true", matchIfMissing = false)
public class SnowflakeRedisAutoConfiguration {


    @Autowired
    private SnowflakeProperties snowflakeProperties;



    @Primary
    @Bean
    @ConditionalOnProperty(value = "spring.redis.mode", havingValue = "standalone", matchIfMissing = true)
    public SnowflakeCacheService snowflakeCacheServiceJedisStandalone(JedisPool jedisPool) {
        return new SnowflakeCacheServiceJedisStandalone(jedisPool);
    }

    @Primary
    @Bean
    @ConditionalOnProperty(value = "spring.redis.mode", havingValue = "cluster", matchIfMissing = false)
    public SnowflakeCacheService snowflakeCacheServiceJedisCluster(JedisCluster jedisCluster) {
        return new SnowflakeCacheServiceJedisCluster(jedisCluster);
    }

    @Primary
    @Bean
    public SnowflakeIdGenerator snowflakeIdGenerator(SnowflakeCacheService snowflakeCacheService){
        int workerId = -1;

        for(int i=0; i< 1024; i++) {

            String key = snowflakeProperties.getCacheKey()+"DATACENTER_"+snowflakeProperties.getDatacenterId()+":WORKER_"+i;
            String result = snowflakeCacheService.setNX(key, "SNOWFLAKE");
            Long ttl = snowflakeCacheService.ttl(key);
            if (!StringUtils.isEmpty(result) && "OK".equals(result) ||  ttl == null || ttl <= 0){
                workerId = i;
                break;
            }
        }

        final String key = snowflakeProperties.getCacheKey()+"DATACENTER_"+snowflakeProperties.getDatacenterId()+":WORKER_"+ workerId;
        if (workerId == -1)
            throw new IllegalStateException("Woker instance has more than volume of 32 ");

        new Thread(){
            @Override
            public void run() {
                while (true) {
                    // 设置7秒过期
                    snowflakeCacheService.expire(key, 7);
                    try{
                        // 每五秒重置一次
                        Thread.sleep(5000);
                    }catch (Exception e){

                    }
                }
            }
        }.start();
        if (snowflakeProperties.getEpochTimestamp() <= 0) {
            return new SnowflakeIdGenerator(workerId, snowflakeProperties.getDatacenterId());
        }
        else {
            return new SnowflakeIdGenerator(workerId, snowflakeProperties.getDatacenterId(), snowflakeProperties.getEpochTimestamp());
        }
    }

}
