package cn.ipokerface.snowflake;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.params.SetParams;

public class SnowflakeCacheServiceJedisStandalone implements SnowflakeCacheService{


    private JedisPool jedisPool;


    public SnowflakeCacheServiceJedisStandalone(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public String setNX(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            return jedis.set(key, value, SetParams.setParams().nx());
        }finally {
            if (jedis !=null) jedis.close();
        }
    }

    @Override
    public Long ttl(String key) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            return jedis.ttl(key);
        }finally {
            if (jedis !=null) jedis.close();
        }
    }

    @Override
    public Long expire(String key, int seconds) {
        Jedis jedis = null;
        try {
            jedis = jedisPool.getResource();
            return jedis.expire(key, seconds);
        }finally {
            if (jedis !=null) jedis.close();
        }
    }
}
