package cn.ipokerface.snowflake;

import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.params.SetParams;

public class SnowflakeCacheServiceJedisCluster implements SnowflakeCacheService{

    private JedisCluster jedisCluster;

    public SnowflakeCacheServiceJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public String setNX(String key, String value) {
        return jedisCluster.set(key, value, SetParams.setParams().nx());
    }

    @Override
    public Long ttl(String key) {
        return jedisCluster.ttl(key);
    }

    @Override
    public Long expire(String key, int seconds) {
        return jedisCluster.expire(key, seconds);
    }
}
