/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.snowflake;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.spring.JedisAutoConfiguration;
import cn.ipokerface.snowflake.SnowflakeIdGenerator;
import cn.ipokerface.snowflake.SnowflakeProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import redis.clients.jedis.params.SetParams;

@Configuration
@EnableConfigurationProperties(value={SnowflakeProperties.class})
@AutoConfigureAfter(value={JedisAutoConfiguration.class})
public class SnowflakeRedisAutoConfiguration {
    @Autowired
    private JedisClient jedisClient;
    @Autowired
    private SnowflakeProperties snowflakeProperties;

    @Bean
    public SnowflakeIdGenerator snowflakeIdGenerator() {
        int workerId = -1;
        for (int i = 0; i < 32; ++i) {
            String key = this.snowflakeProperties.getCacheKey() + ":WORKER_" + i;
            String result = this.jedisClient.set(key, "SNOW_FLAKE", SetParams.setParams().nx());
            Long ttl = this.jedisClient.ttl(key);
            if ((StringUtils.isEmpty((Object)result) || !"OK".equals(result)) && ttl != null && ttl > 0L) continue;
            workerId = i;
            break;
        }
        final String key = this.snowflakeProperties.getCacheKey() + ":WORKER_" + workerId;
        if (workerId == -1) {
            throw new IllegalStateException("Woker instance has more than volume of 32 ");
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    SnowflakeRedisAutoConfiguration.this.jedisClient.expire(key, 7);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }.start();
        if (this.snowflakeProperties.getTwepochTimestamp() == 0L) {
            return new SnowflakeIdGenerator((long)workerId);
        }
        return new SnowflakeIdGenerator((long)workerId, this.snowflakeProperties.getTwepochTimestamp());
    }
}

