package cn.ipokerface.snowflake;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.spring.JedisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import redis.clients.jedis.params.SetParams;

/**
 * Created by       PokerFace
 * Create Date      2021/4/7.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */



@Configuration
@EnableConfigurationProperties({SnowflakeProperties.class})
@AutoConfigureAfter(JedisAutoConfiguration.class)
public class SnowflakeRedisAutoConfiguration {


    @Autowired
    private JedisClient jedisClient;
    @Autowired
    private SnowflakeProperties snowflakeProperties;



    @Bean
    public SnowflakeIdGenerator snowflakeIdGenerator(){
        int workerId = -1;

        for(int i=0; i< 32; i++) {

            String key = snowflakeProperties.getCacheKey()+snowflakeProperties.getDataCenterId()+":WORKER_"+i;
            String result = jedisClient.set(key, "SNOW_FLAKE", SetParams.setParams().nx());
            Long ttl = jedisClient.ttl(key);
            if (!StringUtils.isEmpty(result) && "OK".equals(result) ||  ttl == null || ttl <= 0){
                workerId = i;
                break;
            }
        }

        final String key = snowflakeProperties.getCacheKey()+snowflakeProperties.getDataCenterId()+":WK_"+workerId;
        if (workerId == -1)
            throw new IllegalStateException("Woker instance has more than volume of 32 ");

        new Thread(){
            @Override
            public void run() {
                while (true) {
                    // 设置7秒过期
                    jedisClient.expire(key, 7);
                    try{
                        // 每五秒重置一次
                        Thread.sleep(5000);
                    }catch (Exception e){

                    }
                }
            }
        }.start();
        if (snowflakeProperties.getTwepochTimestamp() == 0) {
            return new SnowflakeIdGenerator(workerId, snowflakeProperties.getDataCenterId());
        }
        else {
            return new SnowflakeIdGenerator(workerId, snowflakeProperties.getDataCenterId(), snowflakeProperties.getTwepochTimestamp());
        }
    }

}
