package cn.ipokerface.api.annotation;

import cn.ipokerface.api.Type;

import java.lang.annotation.*;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Created by       PokerFace
 * Create Date      2019-12-11.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */



@Target({ElementType.METHOD})
@Retention(RUNTIME)
@Documented
@Repeatable(ApiResponse.ApiResponses.class)
public @interface ApiResponse {


    /**
     * Key in parameter list
     *
     */
    String key();



    String name() default "";


    /**
     * if it is required
     *
     */
    boolean contains();


    /**
     *
     * Define the type of this parameter default of String.
     * {@link Type}
     */
    Type type() default Type.String;


    String remark() default "";


    /**
     *
     * Refer to an enum value that usage
     */
    String options() default "";


    /**
     * use to define property of Model. link by key();
     * {@link #key()}
     *
     * useful only the refer parameter key's type is
     * {@link Type#Model} and
     * {@link Type#ModelList}
     *
     */
    String propertyOf() default "";


    /**
     *
     * Define a name of this model or modelList
     *
     */
    String define() default "";


    @Target({ElementType.METHOD})
    @Retention(RUNTIME)
    @Documented
    public @interface ApiResponses{

        ApiResponse[] value();
    }
}
