package cn.ipokerface.api.annotation;

import java.lang.annotation.*;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Created by       PokerFace
 * Create Date      2019-12-10.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Target({ElementType.METHOD})
@Retention(RUNTIME)
@Documented
@Repeatable(ApiHeader.ApiHeaders.class)
public @interface ApiHeader {

    /**
     * Define the Header key
     *
     */
    String key();

    /**
     * Name this header
     *
     */
    String name();


    /**
     * Refer to an {@link ApiEnum} with enum key
     *
     */
    String options() default "";


    @Target({ElementType.METHOD })
    @Retention(RUNTIME)
    @Documented
    public @interface ApiHeaders{

        ApiHeader[] value();
    }


}
