package cn.ipokerface.api.annotation;

import cn.ipokerface.api.Method;
import cn.ipokerface.api.ResponseType;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Created by       PokerFace
 * Create Date      2019-12-09.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Target({ElementType.METHOD})
@Retention(RUNTIME)
@Documented
public @interface Api {

    /**
     * url of this api
     *
     */
    String url() default "";

    /**
     *
     * Name of this api
     */
    String name() default "";

    /**
     *
     * belong to group
     */
    int group() default -1;


    /**
     * Request Method
     *
     *
     */
    Method[] method() default {};


    /**
     *
     *
     */
    ResponseType response() default ResponseType.Json;

}
