package cn.ipokerface.api;

import cn.ipokerface.api.parser.Formatter;

/**
 * Created by       PokerFace
 * Create Date      2019-12-07.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class CoreContext {


    /**
     * Target the output file of this generate task.
     * example:
     * <code>/path/to/file.md</code>
     *
     */
    private String outputFile;


    /**
     * Refer the controller's package name of project.
     * example:
     * <code>com.github.io</code>
     *
     */
    private String packageName;


    /**
     *  Define output formatter type.
     *  {@link Formatter}
     *
     *  example:
     *  <code>Formatter.Markdown</code>
     *
     */
    private Formatter formatter;



    private String title;


    private String description;


    public String getTitle() {
        return title;
    }

    public String getDescription() {
        return description;
    }

    public String getOutputFile() {
        return outputFile;
    }

    public String getPackageName() {
        return packageName;
    }

    public Formatter getFormatter() {
        return formatter;
    }

    public static Builder builder(){
        return new Builder();
    }

    private CoreContext(String path,
                        String packageName,
                        Formatter formatter,
                        String title,
                        String description){
        this.outputFile = path;
        this.packageName = packageName;
        this.formatter = formatter;
        this.title = title;
        this.description = description;

    }





    public static class Builder{

        private String outputFile;

        private String packageName;

        private Formatter formatter;

        private String title;

        private String description;

        private Builder(){

        }

        public Builder info(String title, String description){

            this.title = title;
            this.description = description;
            return this;
        }


        public Builder filePath(String path){
            this.outputFile = path;
            return this;
        }

        public Builder packageName(String packageName){
            this.packageName = packageName;
            return this;
        }

        public Builder type(Formatter formatter){
            this.formatter = formatter;
            return this;
        }


        public CoreContext build(){
            return new CoreContext(outputFile, packageName, formatter, title, description);
        }
    }
}
