package cn.ipokerface.api;

import cn.ipokerface.api.model.Define;
import cn.ipokerface.api.model.Enumeration;
import cn.ipokerface.api.model.Group;
import cn.ipokerface.api.model.SmartApi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2019-12-10.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ConfigurationHolder {


    private List<Enumeration> enumerationList;

    private Map<String, Enumeration> enumerationMap;

    private List<Define> defineList;

    private List<Group> groupList;

    private List<SmartApi> apiList;

    private CoreContext context;


    public ConfigurationHolder(){

    }

    public ConfigurationHolder(CoreContext context,List<Enumeration> enumerationList, List<Define> defineList, List<Group> groupList, List<SmartApi> apiList) {
        this.context = context;
        this.enumerationList = enumerationList;
        this.defineList = defineList;
        this.groupList = groupList;
        this.apiList = apiList;

        enumerationMap = new HashMap<>();
        if(enumerationList!=null){
            for(Enumeration enumeration: enumerationList) {
                enumerationMap.put(enumeration.getKey(), enumeration);
            }
        }
    }

    public List<Enumeration> getEnumerationList() {
        return enumerationList;
    }

    public List<Define> getDefineList() {
        return defineList;
    }

    public List<Group> getGroupList() {
        return groupList;
    }

    public List<SmartApi> getApiList() {
        return apiList;
    }

    public String getTitle() {
        return context.getTitle();
    }

    public String getDescription(){
        return context.getDescription();
    }

    public Enumeration getEnumeration(String key){
        return enumerationMap.get(key);
    }

}
