/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.property.spring;

import cn.ipokerface.property.PropertyResource;
import cn.ipokerface.property.spring.PropertyResourceProperties;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.StringUtils;

public class PropertyResourceRedisService {
    private JedisClient jedisClient;
    private PropertyResourceProperties propertyResourceProperties;

    public PropertyResourceRedisService(JedisClient jedisClient, PropertyResourceProperties propertyResourceProperties) {
        this.jedisClient = jedisClient;
        this.propertyResourceProperties = propertyResourceProperties;
    }

    public void setProperties(List<PropertyResource> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        HashMap updates = new HashMap();
        properties.stream().forEach(item -> updates.put(item.getCode(), item.toJsonString()));
        this.jedisClient.hset(this.propertyResourceProperties.getMapKey(), updates);
    }

    public PropertyResource getProperty(String code) {
        String ret = this.jedisClient.hget(this.propertyResourceProperties.getMapKey(), code);
        if (StringUtils.hasText((String)ret)) {
            return (PropertyResource)((Object)JSON.parseObject((String)ret, PropertyResource.class));
        }
        return null;
    }

    public Map<String, PropertyResource> getProperties() {
        Map result = this.jedisClient.hgetAll(this.propertyResourceProperties.getMapKey());
        HashMap<String, PropertyResource> map = new HashMap<String, PropertyResource>();
        if (MapUtils.isNotEmpty((Map)result)) {
            for (Map.Entry entry : result.entrySet()) {
                map.put((String)entry.getKey(), (PropertyResource)((Object)JSON.parseObject((String)((String)entry.getValue()), PropertyResource.class)));
            }
        }
        return map;
    }

    public Map<String, PropertyResource> getProperties(String ... codes) {
        List result = this.jedisClient.hmget(this.propertyResourceProperties.getMapKey(), codes);
        HashMap<String, PropertyResource> map = new HashMap<String, PropertyResource>();
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            for (String entry : result) {
                PropertyResource resource = (PropertyResource)((Object)JSON.parseObject((String)entry, PropertyResource.class));
                map.put(resource.getCode(), resource);
            }
        }
        return map;
    }
}

