package cn.ipokerface.property.spring;

import cn.ipokerface.common.utils.StringUtils;
import cn.ipokerface.property.PropertyResource;
import cn.ipokerface.redis.JedisClient;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by       PokerFace
 * Create Date      2021/7/19
 * Version          1.0.0
 * Description:
 */



public class PropertyResourceRedisService {

    private JedisClient jedisClient;
    private PropertyResourceProperties propertyResourceProperties;

    public PropertyResourceRedisService(JedisClient jedisClient, PropertyResourceProperties propertyResourceProperties) {
        this.jedisClient = jedisClient;
        this.propertyResourceProperties = propertyResourceProperties;
    }

    /**
     *  update all properties provided. if properties is empty this method will return immediately.
     *
     *
     * @param properties properties to update
     */
    public void setProperties(List<PropertyResource> properties) {
        if (CollectionUtils.isEmpty(properties)) return;
        Map<String,String> updates = new HashMap<>();
        properties.stream().forEach((item)->{
            updates.put(item.getCode(), item.toJsonString());
        });
        jedisClient.hset(propertyResourceProperties.getMapKey(), updates);
    }

    /**
     * get a property config from redis.
     *
     * @param code code of this property
     * @return propertyResource object
     */
    public PropertyResource getProperty(String code) {
        String ret = jedisClient.hget(propertyResourceProperties.getMapKey(), code);
        if (StringUtils.hasText(ret)) return JSON.parseObject(ret, PropertyResource.class);
        return null;
    }


    /**
     *  find all properties.
     *
     * @return all properties
     */
    public Map<String, PropertyResource> getProperties() {
        Map<String,String> result = jedisClient.hgetAll(propertyResourceProperties.getMapKey());
        Map<String, PropertyResource> map = new HashMap<>();
        if(MapUtils.isNotEmpty(result)) {
            for(Map.Entry<String,String> entry: result.entrySet()) {
                map.put(entry.getKey(), JSON.parseObject(entry.getValue(), PropertyResource.class));
            }
        }
        return map;
    }


    /**
     * find multi properties of codes...
     *
     * @param codes codes to find
     * @return map of properties
     */
    public Map<String, PropertyResource> getProperties(String ...codes) {
        List<String> result = jedisClient.hmget(propertyResourceProperties.getMapKey(), codes);
        Map<String, PropertyResource> map = new HashMap<>();
        if(CollectionUtils.isNotEmpty(result)) {
            for(String entry: result) {
                PropertyResource resource = JSON.parseObject(entry, PropertyResource.class);
                map.put(resource.getCode(), resource);
            }
        }
        return map;
    }
}
