package cn.ipokerface.property.spring;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.spring.JedisAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by       PokerFace
 * Create Date      2021/7/19
 * Version          1.0.0
 * Description:
 */


@Configuration
@ConditionalOnBean(JedisClient.class)
@AutoConfigureAfter(JedisAutoConfiguration.class)
@EnableConfigurationProperties(PropertyResourceProperties.class)
public class PropertyResourceAutoConfiguration {

    @Autowired
    private JedisClient jedisClient;
    @Autowired
    private PropertyResourceProperties propertyResourceProperties;

    @Bean
    public PropertyResourceRedisService propertyResourceRedisService() {
        return new PropertyResourceRedisService(jedisClient, propertyResourceProperties);
    }

}
