package cn.ipokerface.property;

import cn.ipokerface.common.model.BaseModel;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * Created by       PokerFace
 * Create Date      2021/7/19
 * Version          1.0.0
 * Description:
 */
public class PropertyResource extends BaseModel {

    private String code;
    private String value;


    public PropertyResource() {
    }

    public PropertyResource(String code, String value) {
        this.code = code;
        this.value = value;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getIntValue() {
        if (StringUtils.isEmpty(value)) return null;
        try {
            return Integer.parseInt(value);
        }catch (Exception e){

        }
        return null;
    }


    public Long getLongValue() {
        if (StringUtils.isEmpty(value)) return null;
        try {
            return Long.parseLong(value);
        }catch (Exception e){

        }
        return null;
    }

    public Boolean getBoolValue() {
        if (StringUtils.isEmpty(value)) return null;
        try {
            return Boolean.parseBoolean(value);
        }catch (Exception e){

        }
        return null;
    }

    public Double getDoubleValue() {
        if (StringUtils.isEmpty(value)) return null;
        try {
            return Double.parseDouble(value);
        }catch (Exception e){

        }
        return null;
    }

    public BigDecimal getDecimalValue() {
        if (StringUtils.isEmpty(value)) return null;
        try {
            return new BigDecimal(value);
        }catch (Exception e){

        }
        return null;
    }
}
