/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.redis;

import cn.ipokerface.redis.JedisClient;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisSimpleClient
implements JedisClient {
    JedisPool jedisPool;

    public JedisSimpleClient(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public String set(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.set(key, value);
        jedis.close();
        return result;
    }

    @Override
    public String set(String key, String value, long expireInMillis) {
        return this.set(key, value, SetParams.setParams().px(expireInMillis));
    }

    @Override
    public String set(String key, String value, SetParams setParams) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.set(key, value, setParams);
        jedis.close();
        return result;
    }

    @Override
    public String multiSet(String ... keyValues) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.mset(keyValues);
        jedis.close();
        return result;
    }

    @Override
    public Long multiSetNx(String ... keyValues) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.msetnx(keyValues);
        jedis.close();
        return result;
    }

    @Override
    public String get(String key) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.get(key);
        jedis.close();
        return result;
    }

    @Override
    public List<String> get(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.mget(keys);
        jedis.close();
        return result;
    }

    @Override
    public Long exists(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.exists(keys);
        jedis.close();
        return result;
    }

    @Override
    public Boolean exists(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.exists(key);
        jedis.close();
        return result;
    }

    @Override
    public Long expire(String key, int seconds) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.expire(key, seconds);
        jedis.close();
        return result;
    }

    @Override
    public Long expire(String key, long timeMillis) {
        return this.expire(key, new Long(timeMillis / 1000L).intValue());
    }

    @Override
    public Long expireAt(String key, long unixTimestamp) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.expireAt(key, unixTimestamp);
        jedis.close();
        return result;
    }

    @Override
    public Long persist(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.persist(key);
        jedis.close();
        return result;
    }

    @Override
    public Long ttl(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.ttl(key);
        jedis.close();
        return result;
    }

    @Override
    public String echo(String string) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.echo(string);
        jedis.close();
        return result;
    }

    @Override
    public Long delete(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.unlink(keys);
        jedis.close();
        return result;
    }

    @Override
    public String type(String key) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.type(key);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> keys(String pattern) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.keys(pattern);
        jedis.close();
        return result;
    }

    @Override
    public Long touch(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.touch(keys);
        jedis.close();
        return result;
    }

    @Override
    public String getSet(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.getSet(key, value);
        jedis.close();
        return result;
    }

    @Override
    public Long increase(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.incr(key);
        jedis.close();
        return result;
    }

    @Override
    public Long increaseBy(String key, long increment) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.incrBy(key, increment);
        jedis.close();
        return result;
    }

    @Override
    public Long decrease(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.decr(key);
        jedis.close();
        return result;
    }

    @Override
    public Long decreaseBy(String key, long decrement) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.decrBy(key, decrement);
        jedis.close();
        return result;
    }

    @Override
    public Double increaseByFloat(String key, float increment) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.incrByFloat(key, (double)increment);
        jedis.close();
        return result;
    }

    @Override
    public Long append(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.append(key, value);
        jedis.close();
        return result;
    }

    @Override
    public String subString(String key, int start, int end) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.substr(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public Boolean setBit(String key, long offset, boolean value) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.setbit(key, offset, value);
        jedis.close();
        return result;
    }

    @Override
    public Boolean setBit(String key, long offset, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.setbit(key, offset, value);
        jedis.close();
        return result;
    }

    @Override
    public Boolean getBit(String key, long offset) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.getbit(key, offset);
        jedis.close();
        return result;
    }

    @Override
    public Long bigCount(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.bitcount(key);
        jedis.close();
        return result;
    }

    @Override
    public Long bitCount(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.bitcount(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public Long bitOp(BitOP op, String destKey, String ... srcKeys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.bitop(op, destKey, srcKeys);
        jedis.close();
        return result;
    }

    @Override
    public List<Long> bitField(String key, String ... arguments) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.bitfield(key, arguments);
        jedis.close();
        return result;
    }

    @Override
    public Long setRange(String key, long offset, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.setrange(key, offset, value);
        jedis.close();
        return result;
    }

    @Override
    public String getRange(String key, long offset, long endOffset) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.getrange(key, offset, endOffset);
        jedis.close();
        return result;
    }

    @Override
    public Long mapSet(String key, String field, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hset(key, field, value);
        jedis.close();
        return result;
    }

    @Override
    public Long mapSet(String key, Map<String, String> map) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hset(key, map);
        jedis.close();
        return result;
    }

    @Override
    public Long mapSetNx(String key, String field, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hsetnx(key, field, value);
        jedis.close();
        return result;
    }

    @Override
    public Long mapIncreaseBy(String key, String field, long value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hincrBy(key, field, value);
        jedis.close();
        return result;
    }

    @Override
    public Double mapIncreaseByFloat(String key, String field, float value) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.hincrByFloat(key, field, (double)value);
        jedis.close();
        return result;
    }

    @Override
    public String mapGet(String key, String field) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.hget(key, field);
        jedis.close();
        return result;
    }

    @Override
    public List<String> mapMultiGet(String key, String ... fields) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.hmget(key, fields);
        jedis.close();
        return result;
    }

    @Override
    public Long mapLength(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hlen(key);
        jedis.close();
        return result;
    }

    @Override
    public Boolean mapExist(String key, String field) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.hexists(key, field);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> mapKeys(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.hkeys(key);
        jedis.close();
        return result;
    }

    @Override
    public List<String> mapValues(String key) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.hvals(key);
        jedis.close();
        return result;
    }

    @Override
    public Map<String, String> mapAll(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Map result = jedis.hgetAll(key);
        jedis.close();
        return result;
    }

    @Override
    public Long mapDelete(String key, String ... fields) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.hdel(key, fields);
        jedis.close();
        return result;
    }

    @Override
    public Long listPush(String key, String ... values) {
        return this.listRightPush(key, values);
    }

    @Override
    public Long listInsert(String key, ListPosition where, String anchor, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.linsert(key, where, anchor, value);
        jedis.close();
        return result;
    }

    @Override
    public Long listRightPush(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.rpush(key, values);
        jedis.close();
        return result;
    }

    @Override
    public Long listRightPushExist(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.rpushx(key, values);
        jedis.close();
        return result;
    }

    @Override
    public Long listLeftPush(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.lpush(key, values);
        jedis.close();
        return result;
    }

    @Override
    public Long listLeftPushExist(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.lpushx(key, values);
        jedis.close();
        return result;
    }

    @Override
    public Long listLength(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.llen(key);
        jedis.close();
        return result;
    }

    @Override
    public List<String> listRange(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.lrange(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public String listTrim(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.ltrim(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public String listIndex(String key, long index) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.lindex(key, index);
        jedis.close();
        return result;
    }

    @Override
    public String listSet(String key, long index, String value) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.lset(key, index, value);
        jedis.close();
        return result;
    }

    @Override
    public Long listRemove(String key, long count, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.lrem(key, count, value);
        jedis.close();
        return result;
    }

    @Override
    public String listPop(String key) {
        return this.listRightPop(key);
    }

    @Override
    public String listRightPop(String key) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.rpop(key);
        jedis.close();
        return result;
    }

    @Override
    public String listLeftPop(String key) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.lpop(key);
        jedis.close();
        return result;
    }

    @Override
    public String listRightPopLeftPush(String srcKey, String targetKey) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.rpoplpush(srcKey, targetKey);
        jedis.close();
        return result;
    }

    @Override
    public List<String> listBlockingLeftPop(int timeout, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.blpop(timeout, keys);
        jedis.close();
        return result;
    }

    @Override
    public List<String> listBlockingRightPop(int timeout, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.brpop(timeout, keys);
        jedis.close();
        return result;
    }

    @Override
    public String listBlockingRightPopLeftPush(String srcKey, String targetKey, int timeout) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.brpoplpush(srcKey, targetKey, timeout);
        jedis.close();
        return result;
    }

    @Override
    public Long setsAdd(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.sadd(key, values);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> setsValues(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.smembers(key);
        jedis.close();
        return result;
    }

    @Override
    public Long setsDelete(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.srem(key, values);
        jedis.close();
        return result;
    }

    @Override
    public String setsPop(String key) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.spop(key);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> setsPop(String key, long count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.spop(key, count);
        jedis.close();
        return result;
    }

    @Override
    public Long setsLength(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.scard(key);
        jedis.close();
        return result;
    }

    @Override
    public Long setsMove(String srcKey, String targetKey, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.smove(srcKey, targetKey, value);
        jedis.close();
        return result;
    }

    @Override
    public Boolean setsExist(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.sismember(key, value);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> setsInter(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.sinter(keys);
        jedis.close();
        return result;
    }

    @Override
    public Long setsInterStore(String destKey, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.sinterstore(destKey, keys);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> setsUnion(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.sunion(keys);
        jedis.close();
        return result;
    }

    @Override
    public Long setsUnionStore(String destKey, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.sunionstore(destKey, keys);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> setsDifferent(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.sdiff(keys);
        jedis.close();
        return result;
    }

    @Override
    public Long setsDifferentStore(String destKey, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.sdiffstore(destKey, keys);
        jedis.close();
        return result;
    }

    @Override
    public String setsRandomValue(String key) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.srandmember(key);
        jedis.close();
        return result;
    }

    @Override
    public List<String> setsRandomValue(String key, int count) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.srandmember(key, count);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetAdd(String key, double score, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zadd(key, score, value);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetAdd(String key, double score, String value, ZAddParams params) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zadd(key, score, value);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetAdd(String key, Map<String, Double> valueScores) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zadd(key, valueScores);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetAdd(String key, Map<String, Double> valueScores, ZAddParams params) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zadd(key, valueScores, params);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRange(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrange(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetDelete(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zrem(key, values);
        jedis.close();
        return result;
    }

    @Override
    public Double zsetIncreaseBy(String key, double increment, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.zincrby(key, increment, value);
        jedis.close();
        return result;
    }

    @Override
    public Double zsetIncreaseBy(String key, double increment, String value, ZIncrByParams params) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.zincrby(key, increment, value, params);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetIndexOf(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zrank(key, value);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetReverseIndexOf(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zrevrank(key, value);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRange(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrevrange(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetRangeWithScores(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeWithScores(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetReverseRangeWithScores(String key, long start, long end) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrevrangeWithScores(key, start, end);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetLength(String key) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zcard(key);
        jedis.close();
        return result;
    }

    @Override
    public Double zsetScore(String key, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.zscore(key, value);
        jedis.close();
        return result;
    }

    @Override
    public List<String> sort(String key) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.sort(key);
        jedis.close();
        return result;
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.sort(key, sortingParameters);
        jedis.close();
        return result;
    }

    @Override
    public Long sortStore(String key, String destKey) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.sort(key, destKey);
        jedis.close();
        return result;
    }

    @Override
    public Long sortStore(String key, SortingParams sortingParameters, String destKey) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.sort(key, sortingParameters, destKey);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRangeByScore(String key, double min, double max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRangeByScore(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRangeByScore(String key, double min, double max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRangeByScore(String key, String min, String max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, double min, double max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, double min, double max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, double min, double max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, String min, String max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScore(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, double min, double max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByScoreWithScores(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetDeleteRangeByIndex(String key, long start, long stop) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zremrangeByRank(key, start, stop);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetDeleteRangeByScore(String key, double min, double max) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zremrangeByScore(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetDeleteRangeByScore(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zremrangeByScore(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetUnionStore(String destKey, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zunionstore(destKey, keys);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetUnionStore(String destKey, ZParams params, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zunionstore(destKey, params, keys);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetInterStore(String destKey, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zinterstore(destKey, keys);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetInterStore(String destKey, ZParams params, String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zinterstore(destKey, params, keys);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetLexLength(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zlexcount(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRangeByLex(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByLex(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetRangeByLex(String key, String min, String max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrangeByLex(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRangeByLex(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrevrangeByLex(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Set<String> zsetReverseRangeByLex(String key, String min, String max, int offset, int count) {
        Jedis jedis = this.jedisPool.getResource();
        Set result = jedis.zrevrangeByLex(key, min, max, offset, count);
        jedis.close();
        return result;
    }

    @Override
    public Long zsetDeleteRangeByLex(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zremrangeByLex(key, min, max);
        jedis.close();
        return result;
    }

    @Override
    public Long geoAdd(String key, double longitude, double latitude, String value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.geoadd(key, longitude, latitude, value);
        jedis.close();
        return result;
    }

    @Override
    public Long geoAdd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.geoadd(key, memberCoordinateMap);
        jedis.close();
        return result;
    }

    @Override
    public Double geoDistant(String key, String source, String target) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.geodist(key, source, target);
        jedis.close();
        return result;
    }

    @Override
    public Double geoDistant(String key, String source, String target, GeoUnit unit) {
        Jedis jedis = this.jedisPool.getResource();
        Double result = jedis.geodist(key, source, target, unit);
        jedis.close();
        return result;
    }

    @Override
    public List<String> geoHash(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.geohash(key, values);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoCoordinate> geoPos(String key, String ... values) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.geopos(key, values);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadius(key, longitude, latitude, radius, unit);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadiusReadonly(key, longitude, latitude, radius, unit);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadius(key, longitude, latitude, radius, unit, param);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadiusReadonly(key, longitude, latitude, radius, unit, param);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMember(String key, String member, double radius, GeoUnit unit) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadiusByMember(key, member, radius, unit);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadiusByMemberReadonly(key, member, radius, unit);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadiusByMember(key, member, radius, unit, param);
        jedis.close();
        return result;
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.georadiusByMemberReadonly(key, member, radius, unit, param);
        jedis.close();
        return result;
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        Jedis jedis = this.jedisPool.getResource();
        jedis.subscribe(jedisPubSub, channels);
        jedis.close();
    }

    @Override
    public Long publish(String channel, String message) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.publish(channel, message);
        jedis.close();
        return result;
    }

    @Override
    public void patternSubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        Jedis jedis = this.jedisPool.getResource();
        jedis.psubscribe(jedisPubSub, patterns);
        jedis.close();
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        Jedis jedis = this.jedisPool.getResource();
        Object result = jedis.eval(script, keys, args);
        jedis.close();
        return result;
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        Jedis jedis = this.jedisPool.getResource();
        Object result = jedis.eval(script, keyCount, params);
        jedis.close();
        return result;
    }

    @Override
    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Object evalSha(String sha1) {
        return this.evalSha(sha1, 0, new String[0]);
    }

    @Override
    public Object evalSha(String sha1, List<String> keys, List<String> args) {
        Jedis jedis = this.jedisPool.getResource();
        Object result = jedis.evalsha(sha1, keys, args);
        jedis.close();
        return result;
    }

    @Override
    public Object evalSha(String sha1, int keyCount, String ... params) {
        Jedis jedis = this.jedisPool.getResource();
        Object result = jedis.evalsha(sha1, keyCount, params);
        jedis.close();
        return result;
    }

    @Override
    public Boolean scriptExists(String sha1) {
        Jedis jedis = this.jedisPool.getResource();
        Boolean result = jedis.scriptExists(sha1);
        jedis.close();
        return result;
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.scriptExists(sha1);
        jedis.close();
        return result;
    }

    @Override
    public String scriptLoad(String script) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.scriptLoad(script);
        jedis.close();
        return result;
    }

    public String watch(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        String result = jedis.watch(keys);
        jedis.close();
        return result;
    }

    public Long move(String key, int dbIndex) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.move(key, dbIndex);
        jedis.close();
        return result;
    }

    public List<String> listBlockingRightPop(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.brpop(keys);
        jedis.close();
        return result;
    }

    public List<String> listBlockingLeftPop(String ... keys) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.blpop(keys);
        jedis.close();
        return result;
    }

    public Long zsetCount(String key, double min, double max) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zcount(key, min, max);
        jedis.close();
        return result;
    }

    public Long zsetCount(String key, String min, String max) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.zcount(key, min, max);
        jedis.close();
        return result;
    }

    public Long bitPos(String key, boolean value) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.bitpos(key, value);
        jedis.close();
        return result;
    }

    public Long bitPos(String key, boolean value, BitPosParams params) {
        Jedis jedis = this.jedisPool.getResource();
        Long result = jedis.bitpos(key, value, params);
        jedis.close();
        return result;
    }

    public List<String> configGet(String pattern) {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.configGet(pattern);
        jedis.close();
        return result;
    }

    public List<Map<String, String>> sentinelMasters() {
        Jedis jedis = this.jedisPool.getResource();
        List result = jedis.sentinelMasters();
        jedis.close();
        return result;
    }
}

