/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.redis;

import cn.ipokerface.redis.JedisClient;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.SafeEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisClusterClient
implements JedisClient {
    private JedisCluster jedisCluster;

    public JedisClusterClient(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    @Override
    public String set(String key, String value) {
        return this.jedisCluster.set(key, value);
    }

    @Override
    public String set(String key, String value, long expireInMillis) {
        return this.jedisCluster.set(key, value, SetParams.setParams().px(expireInMillis));
    }

    @Override
    public String set(String key, String value, SetParams setParams) {
        return this.jedisCluster.set(key, value, setParams);
    }

    @Override
    public String multiSet(String ... keyValues) {
        return this.jedisCluster.mset(keyValues);
    }

    @Override
    public Long multiSetNx(String ... keyValues) {
        return this.jedisCluster.msetnx(keyValues);
    }

    @Override
    public String get(String key) {
        return this.jedisCluster.get(key);
    }

    @Override
    public List<String> get(String ... keys) {
        return this.jedisCluster.mget(keys);
    }

    @Override
    public Long exists(String ... keys) {
        return this.jedisCluster.exists(keys);
    }

    @Override
    public Boolean exists(String key) {
        return this.jedisCluster.exists(key);
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.jedisCluster.expire(key, seconds);
    }

    @Override
    public Long expire(String key, long timeMillis) {
        return this.expire(key, new Long(timeMillis / 1000L).intValue());
    }

    @Override
    public Long expireAt(String key, long unixTimestamp) {
        return this.jedisCluster.expireAt(key, unixTimestamp);
    }

    @Override
    public Long persist(String key) {
        return this.jedisCluster.persist(key);
    }

    @Override
    public Long ttl(String key) {
        return this.jedisCluster.ttl(key);
    }

    @Override
    public String echo(String string) {
        return this.jedisCluster.echo(string);
    }

    @Override
    public Long delete(String ... keys) {
        return this.jedisCluster.unlink(keys);
    }

    @Override
    public String type(String key) {
        return this.jedisCluster.type(key);
    }

    @Override
    public Set<String> keys(String pattern) {
        return this.jedisCluster.keys(pattern);
    }

    @Override
    public Long touch(String ... keys) {
        return this.jedisCluster.touch(keys);
    }

    @Override
    public String getSet(String key, String value) {
        return this.jedisCluster.getSet(key, value);
    }

    @Override
    public Long increase(String key) {
        return this.jedisCluster.incr(key);
    }

    @Override
    public Long increaseBy(String key, long increment) {
        return this.jedisCluster.incrBy(key, increment);
    }

    @Override
    public Long decrease(String key) {
        return this.jedisCluster.decr(key);
    }

    @Override
    public Long decreaseBy(String key, long decrement) {
        return this.jedisCluster.decrBy(key, decrement);
    }

    @Override
    public Double increaseByFloat(String key, float increment) {
        return this.jedisCluster.incrByFloat(key, (double)increment);
    }

    @Override
    public Long append(String key, String value) {
        return this.jedisCluster.append(key, value);
    }

    @Override
    public String subString(String key, int start, int end) {
        return this.jedisCluster.substr(key, start, end);
    }

    @Override
    public Boolean setBit(String key, long offset, boolean value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    @Override
    public Boolean setBit(String key, long offset, String value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    @Override
    public Boolean getBit(String key, long offset) {
        return this.jedisCluster.getbit(key, offset);
    }

    @Override
    public Long bigCount(String key) {
        return this.jedisCluster.bitcount(key);
    }

    @Override
    public Long bitCount(String key, long start, long end) {
        return this.jedisCluster.bitcount(key, start, end);
    }

    @Override
    public Long bitOp(BitOP op, String destKey, String ... srcKeys) {
        return this.jedisCluster.bitop(op, destKey, srcKeys);
    }

    @Override
    public List<Long> bitField(String key, String ... arguments) {
        return this.jedisCluster.bitfield(key, arguments);
    }

    @Override
    public Long setRange(String key, long offset, String value) {
        return this.jedisCluster.setrange(key, offset, value);
    }

    @Override
    public String getRange(String key, long offset, long endOffset) {
        return this.jedisCluster.getrange(key, offset, endOffset);
    }

    @Override
    public Long mapSet(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    @Override
    public Long mapSet(String key, Map<String, String> map) {
        return this.jedisCluster.hset(key, map);
    }

    @Override
    public Long mapSetNx(String key, String field, String value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    @Override
    public Long mapIncreaseBy(String key, String field, long value) {
        return this.jedisCluster.hincrBy(key, field, value);
    }

    @Override
    public Double mapIncreaseByFloat(String key, String field, float value) {
        return this.jedisCluster.hincrByFloat(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), (double)value);
    }

    @Override
    public String mapGet(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }

    @Override
    public List<String> mapMultiGet(String key, String ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    @Override
    public Long mapLength(String key) {
        return this.jedisCluster.hlen(key);
    }

    @Override
    public Boolean mapExist(String key, String field) {
        return this.jedisCluster.hexists(key, field);
    }

    @Override
    public Set<String> mapKeys(String key) {
        return this.jedisCluster.hkeys(key);
    }

    @Override
    public List<String> mapValues(String key) {
        return this.jedisCluster.hvals(key);
    }

    @Override
    public Map<String, String> mapAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    @Override
    public Long mapDelete(String key, String ... fields) {
        return this.jedisCluster.hdel(key, fields);
    }

    @Override
    public Long listPush(String key, String ... values) {
        return this.jedisCluster.rpush(key, values);
    }

    @Override
    public Long listInsert(String key, ListPosition where, String anchor, String value) {
        return this.jedisCluster.linsert(key, where, anchor, value);
    }

    @Override
    public Long listRightPush(String key, String ... values) {
        return this.jedisCluster.rpush(key, values);
    }

    @Override
    public Long listRightPushExist(String key, String ... values) {
        return this.jedisCluster.rpushx(key, values);
    }

    @Override
    public Long listLeftPush(String key, String ... values) {
        return this.jedisCluster.lpush(key, values);
    }

    @Override
    public Long listLeftPushExist(String key, String ... values) {
        return this.jedisCluster.lpushx(key, values);
    }

    @Override
    public Long listLength(String key) {
        return this.jedisCluster.llen(key);
    }

    @Override
    public List<String> listRange(String key, long start, long end) {
        return this.jedisCluster.lrange(key, start, end);
    }

    @Override
    public String listTrim(String key, long start, long end) {
        return this.jedisCluster.ltrim(key, start, end);
    }

    @Override
    public String listIndex(String key, long index) {
        return this.jedisCluster.lindex(key, index);
    }

    @Override
    public String listSet(String key, long index, String value) {
        return this.jedisCluster.lset(key, index, value);
    }

    @Override
    public Long listRemove(String key, long count, String value) {
        return this.jedisCluster.lrem(key, count, value);
    }

    @Override
    public String listPop(String key) {
        return this.listRightPop(key);
    }

    @Override
    public String listRightPop(String key) {
        return this.jedisCluster.rpop(key);
    }

    @Override
    public String listLeftPop(String key) {
        return this.jedisCluster.lpop(key);
    }

    @Override
    public String listRightPopLeftPush(String srcKey, String targetKey) {
        return this.jedisCluster.rpoplpush(srcKey, targetKey);
    }

    @Override
    public List<String> listBlockingLeftPop(int timeout, String ... keys) {
        return this.jedisCluster.blpop(timeout, keys);
    }

    @Override
    public List<String> listBlockingRightPop(int timeout, String ... keys) {
        return this.jedisCluster.brpop(timeout, keys);
    }

    @Override
    public String listBlockingRightPopLeftPush(String srcKey, String targetKey, int timeout) {
        return this.jedisCluster.brpoplpush(srcKey, targetKey, timeout);
    }

    @Override
    public Long setsAdd(String key, String ... values) {
        return this.jedisCluster.sadd(key, values);
    }

    @Override
    public Set<String> setsValues(String key) {
        return this.jedisCluster.smembers(key);
    }

    @Override
    public Long setsDelete(String key, String ... values) {
        return this.jedisCluster.srem(key, values);
    }

    @Override
    public String setsPop(String key) {
        return this.jedisCluster.spop(key);
    }

    @Override
    public Set<String> setsPop(String key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    @Override
    public Long setsLength(String key) {
        return this.jedisCluster.scard(key);
    }

    @Override
    public Long setsMove(String srcKey, String targetKey, String value) {
        return this.jedisCluster.smove(srcKey, targetKey, value);
    }

    @Override
    public Boolean setsExist(String key, String value) {
        return this.jedisCluster.sismember(key, value);
    }

    @Override
    public Set<String> setsInter(String ... keys) {
        return this.jedisCluster.sinter(keys);
    }

    @Override
    public Long setsInterStore(String destKey, String ... keys) {
        return this.jedisCluster.sinterstore(destKey, keys);
    }

    @Override
    public Set<String> setsUnion(String ... keys) {
        return this.jedisCluster.sunion(keys);
    }

    @Override
    public Long setsUnionStore(String destKey, String ... keys) {
        return this.jedisCluster.sinterstore(destKey, keys);
    }

    @Override
    public Set<String> setsDifferent(String ... keys) {
        return this.jedisCluster.sdiff(keys);
    }

    @Override
    public Long setsDifferentStore(String destKey, String ... keys) {
        return this.jedisCluster.sdiffstore(destKey, keys);
    }

    @Override
    public String setsRandomValue(String key) {
        return this.jedisCluster.srandmember(key);
    }

    @Override
    public List<String> setsRandomValue(String key, int count) {
        return this.jedisCluster.srandmember(key, count);
    }

    @Override
    public Long zsetAdd(String key, double score, String value) {
        return this.jedisCluster.zadd(key, score, value);
    }

    @Override
    public Long zsetAdd(String key, double score, String value, ZAddParams params) {
        return this.jedisCluster.zadd(key, score, value, params);
    }

    @Override
    public Long zsetAdd(String key, Map<String, Double> valueScores) {
        return this.jedisCluster.zadd(key, valueScores);
    }

    @Override
    public Long zsetAdd(String key, Map<String, Double> valueScores, ZAddParams params) {
        return this.jedisCluster.zadd(key, valueScores, params);
    }

    @Override
    public Set<String> zsetRange(String key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    @Override
    public Long zsetDelete(String key, String ... values) {
        return this.jedisCluster.zrem(key, values);
    }

    @Override
    public Double zsetIncreaseBy(String key, double increment, String value) {
        return this.jedisCluster.zincrby(key, increment, value);
    }

    @Override
    public Double zsetIncreaseBy(String key, double increment, String value, ZIncrByParams params) {
        return this.jedisCluster.zincrby(key, increment, value, params);
    }

    @Override
    public Long zsetIndexOf(String key, String value) {
        return this.jedisCluster.zrank(key, value);
    }

    @Override
    public Long zsetReverseIndexOf(String key, String value) {
        return this.jedisCluster.zrevrank(key, value);
    }

    @Override
    public Set<String> zsetReverseRange(String key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    @Override
    public Set<Tuple> zsetRangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrangeWithScores(key, start, end);
    }

    @Override
    public Set<Tuple> zsetReverseRangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    @Override
    public Long zsetLength(String key) {
        return this.jedisCluster.zcard(key);
    }

    @Override
    public Double zsetScore(String key, String value) {
        return this.jedisCluster.zscore(key, value);
    }

    @Override
    public List<String> sort(String key) {
        return this.jedisCluster.sort(key);
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        return this.jedisCluster.sort(key, sortingParameters);
    }

    @Override
    public Long sortStore(String key, String destKey) {
        return this.jedisCluster.sort(key, destKey);
    }

    @Override
    public Long sortStore(String key, SortingParams sortingParameters, String destKey) {
        return this.jedisCluster.sort(key, sortingParameters, destKey);
    }

    @Override
    public Set<String> zsetRangeByScore(String key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zsetRangeByScore(String key, String min, String max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zsetRangeByScore(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<String> zsetRangeByScore(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, String min, String max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zsetRangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, String min, String max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<String> zsetReverseRangeByScore(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, String min, String max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zsetReverseRangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Long zsetDeleteRangeByIndex(String key, long start, long end) {
        return this.jedisCluster.zremrangeByRank(key, start, end);
    }

    @Override
    public Long zsetDeleteRangeByScore(String key, double min, double max) {
        return this.jedisCluster.zremrangeByScore(key, min, max);
    }

    @Override
    public Long zsetDeleteRangeByScore(String key, String min, String max) {
        return this.jedisCluster.zremrangeByScore(key, min, max);
    }

    @Override
    public Long zsetUnionStore(String destKey, String ... keys) {
        return this.jedisCluster.zunionstore(destKey, keys);
    }

    @Override
    public Long zsetUnionStore(String destKey, ZParams params, String ... keys) {
        return this.jedisCluster.zunionstore(destKey, params, keys);
    }

    @Override
    public Long zsetInterStore(String destKey, String ... keys) {
        return this.jedisCluster.zinterstore(destKey, keys);
    }

    @Override
    public Long zsetInterStore(String destKey, ZParams params, String ... keys) {
        return this.jedisCluster.zinterstore(destKey, params, keys);
    }

    @Override
    public Long zsetLexLength(String key, String min, String max) {
        return this.jedisCluster.zlexcount(key, min, max);
    }

    @Override
    public Set<String> zsetRangeByLex(String key, String min, String max) {
        return this.jedisCluster.zrangeByLex(key, min, max);
    }

    @Override
    public Set<String> zsetRangeByLex(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Set<String> zsetReverseRangeByLex(String key, String min, String max) {
        return this.jedisCluster.zrevrangeByLex(key, min, max);
    }

    @Override
    public Set<String> zsetReverseRangeByLex(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrevrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Long zsetDeleteRangeByLex(String key, String min, String max) {
        return this.jedisCluster.zremrangeByLex(key, min, max);
    }

    @Override
    public Long geoAdd(String key, double longitude, double latitude, String value) {
        return this.jedisCluster.geoadd(key, longitude, latitude, value);
    }

    @Override
    public Long geoAdd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.jedisCluster.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Double geoDistant(String key, String source, String target) {
        return this.jedisCluster.geodist(key, source, target);
    }

    @Override
    public Double geoDistant(String key, String source, String target, GeoUnit unit) {
        return this.jedisCluster.geodist(key, source, target, unit);
    }

    @Override
    public List<String> geoHash(String key, String ... values) {
        return this.jedisCluster.geohash(key, values);
    }

    @Override
    public List<GeoCoordinate> geoPos(String key, String ... values) {
        return this.jedisCluster.geopos(key, values);
    }

    @Override
    public List<GeoRadiusResponse> geoRadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusReadonly(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> geoRadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusReadonly(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMember(String key, String member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMemberReadonly(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> geoRadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMemberReadonly(key, member, radius, unit, param);
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.jedisCluster.subscribe(jedisPubSub, channels);
    }

    @Override
    public Long publish(String channel, String message) {
        return this.jedisCluster.publish(channel, message);
    }

    @Override
    public void patternSubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.jedisCluster.psubscribe(jedisPubSub, patterns);
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        return this.jedisCluster.eval(script, keys, args);
    }

    @Override
    public Object eval(String script, int keyCount, String ... params) {
        return this.jedisCluster.eval(script, keyCount, params);
    }

    @Override
    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Object evalSha(String sha1) {
        return this.jedisCluster.evalsha(sha1, 0, new String[0]);
    }

    @Override
    public Object evalSha(String sha1, List<String> keys, List<String> args) {
        return this.jedisCluster.evalsha(sha1, keys, args);
    }

    @Override
    public Object evalSha(String sha1, int keyCount, String ... params) {
        return this.jedisCluster.evalsha(sha1, keyCount, params);
    }

    @Override
    public Boolean scriptExists(String sha1) {
        return this.jedisCluster.scriptExists(sha1, "");
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        return this.jedisCluster.scriptExists("", sha1);
    }

    @Override
    public String scriptLoad(String script) {
        return this.jedisCluster.scriptLoad(script, "");
    }
}

