/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JedisClient {
    public static final String RESULT_OK = "OK";
    public static final Long RESULT_WHEN_EXCEPTION = 0L;
    public static final long DEFAULT_TIMEOUT = 15000L;
    public static final String SET_IF_EXIST = "XX";
    public static final String SET_IF_NOT_EXIST = "NX";
    public static final String SET_EXPIRE_TIME_SECOND = "EX";
    public static final String SET_EXPIRE_TIME_MILLISECOND = "PX";

    public String set(String var1, String var2);

    public String set(String var1, String var2, long var3);

    public String set(String var1, String var2, SetParams var3);

    public String multiSet(String ... var1);

    public Long multiSetNx(String ... var1);

    public String get(String var1);

    public List<String> get(String ... var1);

    public Long exists(String ... var1);

    public Boolean exists(String var1);

    public Long expire(String var1, int var2);

    public Long expire(String var1, long var2);

    public Long expireAt(String var1, long var2);

    public Long persist(String var1);

    public Long ttl(String var1);

    public String echo(String var1);

    public Long delete(String ... var1);

    public String type(String var1);

    public Set<String> keys(String var1);

    public Long touch(String ... var1);

    public String getSet(String var1, String var2);

    public Long increase(String var1);

    public Long increaseBy(String var1, long var2);

    public Long decrease(String var1);

    public Long decreaseBy(String var1, long var2);

    public Double increaseByFloat(String var1, float var2);

    public Long append(String var1, String var2);

    public String subString(String var1, int var2, int var3);

    public Boolean setBit(String var1, long var2, boolean var4);

    public Boolean setBit(String var1, long var2, String var4);

    public Boolean getBit(String var1, long var2);

    public Long bigCount(String var1);

    public Long bitCount(String var1, long var2, long var4);

    public Long bitOp(BitOP var1, String var2, String ... var3);

    public List<Long> bitField(String var1, String ... var2);

    public Long setRange(String var1, long var2, String var4);

    public String getRange(String var1, long var2, long var4);

    public Long mapSet(String var1, String var2, String var3);

    public Long mapSet(String var1, Map<String, String> var2);

    public Long mapSetNx(String var1, String var2, String var3);

    public Long mapIncreaseBy(String var1, String var2, long var3);

    public Double mapIncreaseByFloat(String var1, String var2, float var3);

    public String mapGet(String var1, String var2);

    public List<String> mapMultiGet(String var1, String ... var2);

    public Long mapLength(String var1);

    public Boolean mapExist(String var1, String var2);

    public Set<String> mapKeys(String var1);

    public List<String> mapValues(String var1);

    public Map<String, String> mapAll(String var1);

    public Long mapDelete(String var1, String ... var2);

    public Long listPush(String var1, String ... var2);

    public Long listInsert(String var1, ListPosition var2, String var3, String var4);

    public Long listRightPush(String var1, String ... var2);

    public Long listRightPushExist(String var1, String ... var2);

    public Long listLeftPush(String var1, String ... var2);

    public Long listLeftPushExist(String var1, String ... var2);

    public Long listLength(String var1);

    public List<String> listRange(String var1, long var2, long var4);

    public String listTrim(String var1, long var2, long var4);

    public String listIndex(String var1, long var2);

    public String listSet(String var1, long var2, String var4);

    public Long listRemove(String var1, long var2, String var4);

    public String listPop(String var1);

    public String listRightPop(String var1);

    public String listLeftPop(String var1);

    public String listRightPopLeftPush(String var1, String var2);

    public String listBlockingRightPopLeftPush(String var1, String var2, int var3);

    public List<String> listBlockingLeftPop(int var1, String ... var2);

    public List<String> listBlockingRightPop(int var1, String ... var2);

    public Long setsAdd(String var1, String ... var2);

    public Set<String> setsValues(String var1);

    public Long setsDelete(String var1, String ... var2);

    public String setsPop(String var1);

    public Set<String> setsPop(String var1, long var2);

    public Long setsLength(String var1);

    public Long setsMove(String var1, String var2, String var3);

    public Boolean setsExist(String var1, String var2);

    public Set<String> setsInter(String ... var1);

    public Long setsInterStore(String var1, String ... var2);

    public Set<String> setsUnion(String ... var1);

    public Long setsUnionStore(String var1, String ... var2);

    public Set<String> setsDifferent(String ... var1);

    public Long setsDifferentStore(String var1, String ... var2);

    public String setsRandomValue(String var1);

    public List<String> setsRandomValue(String var1, int var2);

    public Long zsetAdd(String var1, double var2, String var4);

    public Long zsetAdd(String var1, double var2, String var4, ZAddParams var5);

    public Long zsetAdd(String var1, Map<String, Double> var2);

    public Long zsetAdd(String var1, Map<String, Double> var2, ZAddParams var3);

    public Set<String> zsetRange(String var1, long var2, long var4);

    public Long zsetDelete(String var1, String ... var2);

    public Double zsetIncreaseBy(String var1, double var2, String var4);

    public Double zsetIncreaseBy(String var1, double var2, String var4, ZIncrByParams var5);

    public Long zsetIndexOf(String var1, String var2);

    public Long zsetReverseIndexOf(String var1, String var2);

    public Set<String> zsetReverseRange(String var1, long var2, long var4);

    public Long zsetLength(String var1);

    public Double zsetScore(String var1, String var2);

    public Set<Tuple> zsetRangeWithScores(String var1, long var2, long var4);

    public Set<String> zsetRangeByScore(String var1, double var2, double var4);

    public Set<String> zsetRangeByScore(String var1, String var2, String var3);

    public Set<String> zsetRangeByScore(String var1, double var2, double var4, int var6, int var7);

    public Set<String> zsetRangeByScore(String var1, String var2, String var3, int var4, int var5);

    public Set<Tuple> zsetRangeByScoreWithScores(String var1, double var2, double var4);

    public Set<Tuple> zsetRangeByScoreWithScores(String var1, String var2, String var3);

    public Set<Tuple> zsetRangeByScoreWithScores(String var1, double var2, double var4, int var6, int var7);

    public Set<Tuple> zsetRangeByScoreWithScores(String var1, String var2, String var3, int var4, int var5);

    public Set<Tuple> zsetReverseRangeWithScores(String var1, long var2, long var4);

    public Set<String> zsetReverseRangeByScore(String var1, double var2, double var4);

    public Set<String> zsetReverseRangeByScore(String var1, String var2, String var3);

    public Set<String> zsetReverseRangeByScore(String var1, double var2, double var4, int var6, int var7);

    public Set<String> zsetReverseRangeByScore(String var1, String var2, String var3, int var4, int var5);

    public Set<Tuple> zsetReverseRangeByScoreWithScores(String var1, double var2, double var4);

    public Set<Tuple> zsetReverseRangeByScoreWithScores(String var1, String var2, String var3);

    public Set<Tuple> zsetReverseRangeByScoreWithScores(String var1, double var2, double var4, int var6, int var7);

    public Set<Tuple> zsetReverseRangeByScoreWithScores(String var1, String var2, String var3, int var4, int var5);

    public Long zsetDeleteRangeByIndex(String var1, long var2, long var4);

    public Long zsetDeleteRangeByScore(String var1, double var2, double var4);

    public Long zsetDeleteRangeByScore(String var1, String var2, String var3);

    public Long zsetUnionStore(String var1, String ... var2);

    public Long zsetUnionStore(String var1, ZParams var2, String ... var3);

    public Long zsetInterStore(String var1, String ... var2);

    public Long zsetInterStore(String var1, ZParams var2, String ... var3);

    public Long zsetLexLength(String var1, String var2, String var3);

    public Set<String> zsetRangeByLex(String var1, String var2, String var3);

    public Set<String> zsetRangeByLex(String var1, String var2, String var3, int var4, int var5);

    public Set<String> zsetReverseRangeByLex(String var1, String var2, String var3);

    public Set<String> zsetReverseRangeByLex(String var1, String var2, String var3, int var4, int var5);

    public Long zsetDeleteRangeByLex(String var1, String var2, String var3);

    public List<String> sort(String var1);

    public List<String> sort(String var1, SortingParams var2);

    public Long sortStore(String var1, String var2);

    public Long sortStore(String var1, SortingParams var2, String var3);

    public Long geoAdd(String var1, double var2, double var4, String var6);

    public Long geoAdd(String var1, Map<String, GeoCoordinate> var2);

    public Double geoDistant(String var1, String var2, String var3);

    public Double geoDistant(String var1, String var2, String var3, GeoUnit var4);

    public List<String> geoHash(String var1, String ... var2);

    public List<GeoCoordinate> geoPos(String var1, String ... var2);

    public List<GeoRadiusResponse> geoRadius(String var1, double var2, double var4, double var6, GeoUnit var8);

    public List<GeoRadiusResponse> geoRadiusReadonly(String var1, double var2, double var4, double var6, GeoUnit var8);

    public List<GeoRadiusResponse> geoRadius(String var1, double var2, double var4, double var6, GeoUnit var8, GeoRadiusParam var9);

    public List<GeoRadiusResponse> geoRadiusReadonly(String var1, double var2, double var4, double var6, GeoUnit var8, GeoRadiusParam var9);

    public List<GeoRadiusResponse> geoRadiusByMember(String var1, String var2, double var3, GeoUnit var5);

    public List<GeoRadiusResponse> geoRadiusByMemberReadonly(String var1, String var2, double var3, GeoUnit var5);

    public List<GeoRadiusResponse> geoRadiusByMember(String var1, String var2, double var3, GeoUnit var5, GeoRadiusParam var6);

    public List<GeoRadiusResponse> geoRadiusByMemberReadonly(String var1, String var2, double var3, GeoUnit var5, GeoRadiusParam var6);

    public void subscribe(JedisPubSub var1, String ... var2);

    public Long publish(String var1, String var2);

    public void patternSubscribe(JedisPubSub var1, String ... var2);

    public Object eval(String var1, List<String> var2, List<String> var3);

    public Object eval(String var1, int var2, String ... var3);

    public Object eval(String var1);

    public Object evalSha(String var1);

    public Object evalSha(String var1, List<String> var2, List<String> var3);

    public Object evalSha(String var1, int var2, String ... var3);

    public Boolean scriptExists(String var1);

    public List<Boolean> scriptExists(String ... var1);

    public String scriptLoad(String var1);
}

