package cn.ipokerface.redis.spring;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * Created by       PokerFace
 * Create Date      2019-11-27.
 * Email:           mailto:214888341@163.com
 * Version          1.0.0
 * <p>
 * Description:
 */


@Component
@ConfigurationProperties(prefix = "spring.redis")
public class JedisProperties {


    // mode : standalone | cluster
    private String mode             = "standalone";

    /**
     * if use single redis-server . please set host/port and password if needed.
     */
    private String host;

    /**
     * if use single redis-server .
     */
    private Integer port;

    /**
     * if use single redis-server .
     */
    private String password;


    /**
     *  database to select default 0;
     */
    private int database = 0;

    /**
     * Connection command timeout.
     */
    private Integer timeout = 20000;


    // cluster config
    private int connectionTimeout = 30000;

    private int socketTimeout = 30000;

    private int maxAttempts = 3;

    private String clusterName;

    private List<String> clusters;




    /**
     * Max Idle connection in pool
     */
    private Integer maxIdle;
    /**
     * Min Idle connection in pool
     */
    private Integer minIdle;
    /**
     * Max connection count in pool
     */
    private Integer maxTotal;
    /**
     * Max wait time millis.
     */
    private Integer maxWaitMillis = 1000;
    /**
     *
     */
    private Integer minEvictableIdleTimeMillis = 30000;
    /**
     * Test count each time.
     */
    private Integer numTestsPerEvictionRun = 1024;
    /**
     *
     */
    private long timeBetweenEvictionRunsMillis = 30000;

    /**
     * if test when get resource or not
     */
    private boolean testOnBorrow  = true;

    /**
     * if test when reousrce is idle. default is true
     */
    private boolean testWhileIdle = true;

    /**
     * if test when create pool
     */
    private boolean testOnCreate = false;


    public Integer getMaxIdle() {
        return maxIdle;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public Integer getMinIdle() {
        return minIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public Integer getMaxTotal() {
        return maxTotal;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public Integer getMaxWaitMillis() {
        return maxWaitMillis;
    }

    public void setMaxWaitMillis(Integer maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public Integer getMinEvictableIdleTimeMillis() {
        return minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(Integer minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public Integer getNumTestsPerEvictionRun() {
        return numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(Integer numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public boolean isTestOnBorrow() {
        return testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestWhileIdle() {
        return testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public boolean isTestOnCreate() {
        return testOnCreate;
    }

    public void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
    }


    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getMaxAttempts() {
        return maxAttempts;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public String getClusterName() {
        return clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public List<String> getClusters() {
        return clusters;
    }

    public void setClusters(List<String> clusters) {
        this.clusters = clusters;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}
