/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.redis.spring;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.JedisClientCluster;
import cn.ipokerface.redis.JedisClientStandalone;
import cn.ipokerface.redis.spring.JedisProperties;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@ConditionalOnProperty(name={"spring.redis.enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={JedisProperties.class})
@Configuration
public class JedisAutoConfiguration {
    @Autowired
    private JedisProperties jedisProperties;

    @Bean
    @ConditionalOnMissingBean(value={JedisPoolConfig.class})
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(this.jedisProperties.getMaxTotal().intValue());
        jedisPoolConfig.setMaxIdle(this.jedisProperties.getMaxIdle().intValue());
        jedisPoolConfig.setMinIdle(this.jedisProperties.getMinIdle().intValue());
        jedisPoolConfig.setMaxWaitMillis((long)this.jedisProperties.getMaxWaitMillis().intValue());
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)this.jedisProperties.getMinEvictableIdleTimeMillis().intValue());
        jedisPoolConfig.setNumTestsPerEvictionRun(this.jedisProperties.getNumTestsPerEvictionRun().intValue());
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(this.jedisProperties.getTimeBetweenEvictionRunsMillis());
        jedisPoolConfig.setTestOnBorrow(this.jedisProperties.isTestOnBorrow());
        jedisPoolConfig.setTestWhileIdle(this.jedisProperties.isTestWhileIdle());
        jedisPoolConfig.setTestOnCreate(this.jedisProperties.isTestOnCreate());
        return jedisPoolConfig;
    }

    @Primary
    @Bean
    @ConditionalOnProperty(value={"spring.redis.mode"}, havingValue="standalone", matchIfMissing=true)
    public JedisPool jedisPool(JedisPoolConfig jedisPoolConfig) {
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.jedisProperties.getHost(), this.jedisProperties.getPort().intValue(), this.jedisProperties.getTimeout().intValue(), this.jedisProperties.getPassword(), this.jedisProperties.getDatabase());
    }

    @Primary
    @Bean
    @ConditionalOnProperty(value={"spring.redis.mode"}, havingValue="standalone", matchIfMissing=true)
    public JedisClient jedisClientStandalone(JedisPool jedisPool) {
        return new JedisClientStandalone(jedisPool);
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class, JedisCluster.class})
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="cluster", matchIfMissing=false)
    public JedisCluster jedisCluster(JedisPoolConfig jedisPoolConfig) {
        HashSet<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        if (CollectionUtils.isEmpty(this.jedisProperties.getClusters())) {
            throw new IllegalArgumentException("redis cluster nodes is not set!");
        }
        for (String ipPort : this.jedisProperties.getClusters()) {
            String[] ipAndPorts = ipPort.split(":");
            if (ipAndPorts == null || ipAndPorts.length != 2) {
                throw new IllegalArgumentException("Invalid ip and port of node:" + ipPort);
            }
            hostAndPorts.add(new HostAndPort(ipAndPorts[0], Integer.parseInt(ipAndPorts[1])));
        }
        return new JedisCluster(hostAndPorts, this.jedisProperties.getConnectionTimeout(), this.jedisProperties.getSocketTimeout(), this.jedisProperties.getMaxAttempts(), this.jedisProperties.getPassword(), this.jedisProperties.getClusterName(), (GenericObjectPoolConfig)jedisPoolConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisClient.class, JedisClientStandalone.class})
    @ConditionalOnProperty(name={"spring.redis.mode"}, havingValue="cluster", matchIfMissing=false)
    public JedisClient jedisClientCluster(JedisCluster jedisCluster) {
        return new JedisClientCluster(jedisCluster);
    }
}

