/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.redis.spring;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.JedisClientCluster;
import cn.ipokerface.redis.JedisClientStandalone;
import cn.ipokerface.redis.spring.JedisClusterProperties;
import cn.ipokerface.redis.spring.JedisPoolProperties;
import cn.ipokerface.redis.spring.JedisProperties;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@ConditionalOnProperty(name={"spring.redis.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={JedisPoolProperties.class, JedisProperties.class, JedisClusterProperties.class})
@Configuration
public class JedisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={JedisPoolConfig.class})
    public JedisPoolConfig jedisPoolConfig(JedisPoolProperties jedisPoolProperties) {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(jedisPoolProperties.getMaxTotal().intValue());
        jedisPoolConfig.setMaxIdle(jedisPoolProperties.getMaxIdle().intValue());
        jedisPoolConfig.setMinIdle(jedisPoolProperties.getMinIdle().intValue());
        jedisPoolConfig.setMaxWaitMillis((long)jedisPoolProperties.getMaxWaitMillis().intValue());
        jedisPoolConfig.setMinEvictableIdleTimeMillis((long)jedisPoolProperties.getMinEvictableIdleTimeMillis().intValue());
        jedisPoolConfig.setNumTestsPerEvictionRun(jedisPoolProperties.getNumTestsPerEvictionRun().intValue());
        jedisPoolConfig.setTimeBetweenEvictionRunsMillis(jedisPoolProperties.getTimeBetweenEvictionRunsMillis());
        jedisPoolConfig.setTestOnBorrow(jedisPoolProperties.isTestOnBorrow());
        jedisPoolConfig.setTestWhileIdle(jedisPoolProperties.isTestWhileIdle());
        jedisPoolConfig.setTestOnCreate(jedisPoolProperties.isTestOnCreate());
        return jedisPoolConfig;
    }

    @Primary
    @Bean
    @ConditionalOnProperty(value={"spring.redis.standalone"}, matchIfMissing=true)
    public JedisPool jedisPool(JedisPoolConfig jedisPoolConfig, JedisProperties jedisProperties) {
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, jedisProperties.getHost(), jedisProperties.getPort().intValue(), jedisProperties.getTimeout().intValue(), jedisProperties.getPassword(), jedisProperties.getDatabase());
    }

    @Primary
    @Bean
    @ConditionalOnProperty(value={"spring.redis.standalone"}, matchIfMissing=true)
    public JedisClient jedisClientStandalone(JedisPool jedisPool) {
        return new JedisClientStandalone(jedisPool);
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class, JedisCluster.class})
    @ConditionalOnProperty(name={"spring.redis.standalone"}, havingValue="false", matchIfMissing=false)
    public JedisCluster jedisCluster(JedisPoolConfig jedisPoolConfig, JedisClusterProperties jedisClusterProperties) {
        HashSet<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        if (CollectionUtils.isEmpty(jedisClusterProperties.getClusterNodes())) {
            throw new IllegalArgumentException("redis cluster nodes is not set!");
        }
        for (String ipPort : jedisClusterProperties.getClusterNodes()) {
            String[] ipAndPorts = ipPort.split(":");
            if (ipAndPorts == null || ipAndPorts.length != 2) {
                throw new IllegalArgumentException("Invalid ip and port of node:" + ipPort);
            }
            hostAndPorts.add(new HostAndPort(ipAndPorts[0], Integer.parseInt(ipAndPorts[1])));
        }
        return new JedisCluster(hostAndPorts, jedisClusterProperties.getConnectionTimeout(), jedisClusterProperties.getSocketTimeout(), jedisClusterProperties.getMaxAttempts(), jedisClusterProperties.getPassword(), jedisClusterProperties.getClusterName(), (GenericObjectPoolConfig)jedisPoolConfig);
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisClient.class, JedisClientStandalone.class})
    @ConditionalOnProperty(name={"spring.redis.standalone"}, havingValue="false", matchIfMissing=false)
    public JedisClient jedisClientCluster(JedisCluster jedisCluster) {
        return new JedisClientCluster(jedisCluster);
    }
}

