package cn.ipokerface.redis.spring;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Created by       PokerFace
 * Create Date      2019-11-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Component
@ConfigurationProperties(prefix = "spring.redis")
public class JedisProperties {

    /**
     * if use single redis-server . please set host/port and password if needed.
     */
    private String host;

    /**
     * if use single redis-server .
     */
    private Integer port;

    /**
     * if use single redis-server .
     */
    private String password;


    /**
     *  database to select default 0;
     */
    private int database = 0;

    /**
     * Connection command timeout.
     */
    private Integer timeout = 20000;


    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }
}
