/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.redis.spring;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.JedisClusterClient;
import cn.ipokerface.redis.JedisSimpleClient;
import cn.ipokerface.redis.spring.RedisProperties;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@ConditionalOnProperty(name={"spring.redis.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={RedisProperties.class})
public class JedisClientAutoConfiguration {
    @Autowired
    RedisProperties redisProperties;

    @Bean
    @ConditionalOnMissingBean(value={JedisPoolConfig.class})
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(this.redisProperties.getMaxTotal().intValue());
        poolConfig.setMaxIdle(this.redisProperties.getMaxIdle().intValue());
        poolConfig.setMinIdle(this.redisProperties.getMinIdle().intValue());
        poolConfig.setMaxWaitMillis((long)this.redisProperties.getMaxWaitMillis().intValue());
        poolConfig.setMinEvictableIdleTimeMillis((long)this.redisProperties.getMinEvictableIdleTimeMillis().intValue());
        poolConfig.setNumTestsPerEvictionRun(this.redisProperties.getNumTestsPerEvictionRun().intValue());
        poolConfig.setTimeBetweenEvictionRunsMillis(this.redisProperties.getTimeBetweenEvictionRunsMillis());
        poolConfig.setTestOnBorrow(this.redisProperties.isTestOnBorrow());
        poolConfig.setTestWhileIdle(this.redisProperties.isTestWhileIdle());
        return poolConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class, JedisCluster.class})
    @ConditionalOnProperty(name={"spring.redis.cluster"}, matchIfMissing=true, havingValue="false")
    public JedisPool jedisPool(JedisPoolConfig jedisPoolConfig) {
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.redisProperties.getHost(), this.redisProperties.getPort().intValue(), this.redisProperties.getTimeout().intValue(), this.redisProperties.getPassword(), this.redisProperties.getDatabase());
    }

    @Bean
    @ConditionalOnMissingBean(value={JedisPool.class, JedisCluster.class})
    @ConditionalOnProperty(name={"spring.redis.cluster"}, havingValue="true")
    public JedisCluster jedisCluster(JedisPoolConfig jedisPoolConfig) {
        HashSet<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        if (StringUtils.isEmpty((Object)this.redisProperties.getClusterNodes())) {
            throw new IllegalStateException("cluster Nodes does not exist");
        }
        String[] ipPorts = this.redisProperties.getClusterNodes().split(",");
        if (ipPorts != null && ipPorts.length > 0) {
            for (String ipPort : ipPorts) {
                String[] ipAndPorts = ipPort.split(":");
                if (ipAndPorts == null || ipAndPorts.length != 2) {
                    throw new IllegalArgumentException("Invalid ip and port of node:" + ipPort);
                }
                hostAndPorts.add(new HostAndPort(ipAndPorts[0], Integer.parseInt(ipAndPorts[1])));
            }
        }
        return new JedisCluster(hostAndPorts, this.redisProperties.getConnectionTimeout(), this.redisProperties.getSocketTimeout(), this.redisProperties.getMaxAttempts(), this.redisProperties.getPassword(), this.redisProperties.getClusterName(), (GenericObjectPoolConfig)jedisPoolConfig);
    }

    @Bean
    @ConditionalOnBean(value={JedisPool.class})
    @ConditionalOnProperty(name={"spring.redis.cluster"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnMissingBean(value={JedisClient.class})
    public JedisSimpleClient jedisSimpleClient(JedisPool jedisPool) {
        return new JedisSimpleClient(jedisPool);
    }

    @Bean
    @ConditionalOnBean(value={JedisCluster.class})
    @ConditionalOnProperty(name={"spring.redis.cluster"}, havingValue="true")
    @ConditionalOnMissingBean(value={JedisClient.class})
    public JedisClusterClient jedisClusterClient(JedisCluster jedisCluster) {
        return new JedisClusterClient(jedisCluster);
    }
}

