package cn.ipokerface.redis.spring;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * Created by       PokerFace
 * Create Date      2019-11-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */


@Component
@ConfigurationProperties(prefix = "spring.redis")
public class RedisProperties {

    /**
     *  Enable redis-client or not
     *  default true
     *
     */
    private boolean enabled = true;

    /**
     *  is redis server cluster or not. default is false
     *
     */
    private boolean cluster = false;

    /**
     * if use single redis-server . please set host/port and password if needed.
     */
    private String host;

    /**
     * if use single redis-server .
     */
    private Integer port;

    /**
     * if use single redis-server .
     */
    private String password;


    /**
     *  database to select default 0;
     */
    private int database = 0;

    /**
     * set this value if use cluster redis-server.
     */
    private String clusterNodes;

    /**
     * Connection command timeout.
     */
    private Integer timeout;

    /**
     * Max Idle connection in pool
     */
    private Integer maxIdle;

    /**
     * Min Idle connection in pool
     */
    private Integer minIdle;

    /**
     * Max connection count in pool
     */
    private Integer maxTotal;


    /**
     * cluster connectionTimeout
     */
    private int connectionTimeout = 2000;

    /**
     * cluster socketTimeout
     */
    private int socketTimeout = 2000;


    /**
     * cluster maxAttempts time
     */
    private int maxAttempts = 5;


    /**
     * cluster Name
     */
    private String clusterName;


    /**
     * Max wait time millis.
     */
    private Integer maxWaitMillis = 1000;

    /**
     *
     */
    private Integer minEvictableIdleTimeMillis = 30000;

    /**
     * Test count each time.
     */
    private Integer numTestsPerEvictionRun = 1024;

    /**
     *
     */
    private long timeBetweenEvictionRunsMillis = 30000;

    /**
     * if test when get resource or not
     */
    private boolean testOnBorrow  = true;

    /**
     * if test when reousrce is idle. default is true
     */
    private boolean testWhileIdle = true;


    public boolean isEnabled() {
        return enabled;
    }

    public boolean isCluster() {
        return cluster;
    }

    public String getHost() {
        return host;
    }

    public Integer getPort() {
        return port;
    }

    public String getPassword() {
        return password;
    }

    public int getDatabase() {
        return database;
    }

    public String getClusterNodes() {
        return clusterNodes;
    }

    public Integer getTimeout() {
        return timeout;
    }

    public Integer getMaxIdle() {
        return maxIdle;
    }

    public Integer getMinIdle() {
        return minIdle;
    }

    public Integer getMaxTotal() {
        return maxTotal;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public int getSocketTimeout() {
        return socketTimeout;
    }

    public int getMaxAttempts() {
        return maxAttempts;
    }

    public String getClusterName() {
        return clusterName;
    }

    public Integer getMaxWaitMillis() {
        return maxWaitMillis;
    }

    public Integer getMinEvictableIdleTimeMillis() {
        return minEvictableIdleTimeMillis;
    }

    public Integer getNumTestsPerEvictionRun() {
        return numTestsPerEvictionRun;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return timeBetweenEvictionRunsMillis;
    }

    public boolean isTestOnBorrow() {
        return testOnBorrow;
    }

    public boolean isTestWhileIdle() {
        return testWhileIdle;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCluster(boolean cluster) {
        this.cluster = cluster;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClusterNodes(String clusterNodes) {
        this.clusterNodes = clusterNodes;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxIdle(Integer maxIdle) {
        this.maxIdle = maxIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMaxWaitMillis(Integer maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public void setMinEvictableIdleTimeMillis(Integer minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public void setNumTestsPerEvictionRun(Integer numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }
}
