package cn.ipokerface.redis.spring;

import cn.ipokerface.redis.JedisClient;
import cn.ipokerface.redis.JedisClusterClient;
import cn.ipokerface.redis.JedisSimpleClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import java.util.HashSet;
import java.util.Set;

/**
 * Created by       PokerFace
 * Create Date      2019-11-27.
 * Email:           <a href="mailto:214888341@163.com">214888341@163.com</a>
 * Version          1.0.0
 * <p>
 * Description:
 */

@Configuration
@ConditionalOnProperty(name = "spring.redis.enabled", matchIfMissing = true)
@EnableConfigurationProperties(RedisProperties.class)
public class JedisClientAutoConfiguration {


    @Autowired
    RedisProperties redisProperties;


    @Bean
    @ConditionalOnMissingBean(JedisPoolConfig.class)
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(redisProperties.getMaxTotal());
        poolConfig.setMaxIdle(redisProperties.getMaxIdle());
        poolConfig.setMinIdle(redisProperties.getMinIdle());
        poolConfig.setMaxWaitMillis(redisProperties.getMaxWaitMillis());
        poolConfig.setMinEvictableIdleTimeMillis(redisProperties.getMinEvictableIdleTimeMillis());
        poolConfig.setNumTestsPerEvictionRun(redisProperties.getNumTestsPerEvictionRun());
        poolConfig.setTimeBetweenEvictionRunsMillis(redisProperties.getTimeBetweenEvictionRunsMillis());
        poolConfig.setTestOnBorrow(redisProperties.isTestOnBorrow());
        poolConfig.setTestWhileIdle(redisProperties.isTestWhileIdle());
        return poolConfig;
    }



    @Bean
    @ConditionalOnMissingBean({JedisPool.class, JedisCluster.class})
    @ConditionalOnProperty(name = "spring.redis.cluster", matchIfMissing = true, havingValue = "false")
    public JedisPool jedisPool(JedisPoolConfig jedisPoolConfig)
    {
        System.out.println("1111111111111111111111");
        return new JedisPool(jedisPoolConfig,
                redisProperties.getHost(),
                redisProperties.getPort(),
                redisProperties.getTimeout(),
                redisProperties.getPassword());
    }


    @Bean
    @ConditionalOnMissingBean({JedisPool.class, JedisCluster.class})
    @ConditionalOnProperty(name = "spring.redis.cluster", havingValue = "true")
    public JedisCluster jedisCluster(JedisPoolConfig jedisPoolConfig)
    {
        Set<HostAndPort> hostAndPorts = new HashSet<HostAndPort>();
        if (StringUtils.isEmpty(redisProperties.getClusterNodes()))
            throw new IllegalStateException("cluster Nodes does not exist");

        String[] ipPorts = redisProperties.getClusterNodes().split(",");
        if(ipPorts != null && ipPorts.length > 0){
            for(String ipPort: ipPorts){
                String[] ipAndPorts = ipPort.split(":");
                if (ipAndPorts == null || ipAndPorts.length != 2)
                    throw new IllegalArgumentException("Invalid ip and port of node:"+ ipPort);
                hostAndPorts.add(new HostAndPort(ipAndPorts[0], Integer.parseInt(ipAndPorts[1])));
            }
        }
        System.out.println("2222222222222222222222");

        return new JedisCluster(hostAndPorts,
                redisProperties.getConnectionTimeout(),
                redisProperties.getSocketTimeout(),
                redisProperties.getMaxAttempts(),
                redisProperties.getPassword(),
                redisProperties.getClusterName(),
                jedisPoolConfig);
    }


    @Bean
    @ConditionalOnBean(JedisPool.class)
    @ConditionalOnProperty(name = "spring.redis.cluster", havingValue = "false", matchIfMissing = true)
    @ConditionalOnMissingBean(JedisClient.class)
    public JedisSimpleClient jedisSimpleClient(JedisPool jedisPool)
    {
        return new JedisSimpleClient(jedisPool);
    }


    @Bean
    @ConditionalOnBean(JedisCluster.class)
    @ConditionalOnProperty(name = "spring.redis.cluster", havingValue = "true")
    @ConditionalOnMissingBean(JedisClient.class)
    public JedisClusterClient jedisClusterClient(JedisCluster jedisCluster)
    {
        return new JedisClusterClient(jedisCluster);
    }








}
