/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.netty.server.connection;

import cn.ipokerface.netty.server.connection.ConnectionManager;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerInboundHandlerAdapter
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionManagerInboundHandlerAdapter.class);
    private ConnectionManager connectionManager;

    public ConnectionManagerInboundHandlerAdapter(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        logger.trace("Received Connection from IP[" + inetSocketAddress.getAddress().getHostAddress() + "] PORT[" + inetSocketAddress.getPort() + "]");
        if (this.connectionManager != null) {
            this.connectionManager.receivedConnection(ctx);
        }
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        logger.trace("Connection Closed from IP[" + inetSocketAddress.getAddress().getHostAddress() + "] PORT[" + inetSocketAddress.getPort() + "]");
        if (this.connectionManager != null) {
            this.connectionManager.removeConnection(ctx);
        }
        super.channelInactive(ctx);
    }
}

