/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.netty.server.connection;

import cn.ipokerface.netty.NettyContext;
import cn.ipokerface.netty.connection.Connection;
import cn.ipokerface.netty.server.NettyServer;
import cn.ipokerface.netty.server.connection.ConnectionListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private NettyServer serverContext;
    private ConcurrentHashMap<Channel, Connection> contextConnectionMap;
    private ConnectionListener connectionListener;

    public ConnectionManager(NettyServer context) {
        this.serverContext = context;
        this.contextConnectionMap = new ConcurrentHashMap();
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public synchronized void receivedConnection(ChannelHandlerContext context) {
        Connection connection = this.contextConnectionMap.get(context.channel());
        if (connection == null) {
            connection = new Connection((NettyContext)this.serverContext, context);
            this.contextConnectionMap.put(context.channel(), connection);
        }
        if (this.connectionListener != null) {
            this.connectionListener.connectionConnected(connection);
        }
    }

    public synchronized void removeConnection(ChannelHandlerContext context) {
        Connection connection = this.contextConnectionMap.remove(context.channel());
        if (this.connectionListener != null) {
            this.connectionListener.connectionDisconnected(connection);
        }
    }

    public Connection getConnection(ChannelHandlerContext context) {
        Connection connection = this.contextConnectionMap.get(context.channel());
        return connection;
    }
}

