/*
 * Decompiled with CFR 0.152.
 */
package cn.ipokerface.netty.server;

import cn.ipokerface.netty.NettyContext;
import cn.ipokerface.netty.connection.Connection;
import cn.ipokerface.netty.message.Request;
import cn.ipokerface.netty.protocol.PacketInboundHandlerAdapter;
import cn.ipokerface.netty.protocol.ProtocolInboundHandlerFrameDecoder;
import cn.ipokerface.netty.request.RequestHandler;
import cn.ipokerface.netty.request.RequestInboundHandlerAdapter;
import cn.ipokerface.netty.request.ResponseListener;
import cn.ipokerface.netty.request.interceptor.AfterHandlerInterceptor;
import cn.ipokerface.netty.request.interceptor.BeforeHandlerInterceptor;
import cn.ipokerface.netty.server.connection.ConnectionListener;
import cn.ipokerface.netty.server.connection.ConnectionManager;
import cn.ipokerface.netty.server.connection.ConnectionManagerInboundHandlerAdapter;
import cn.ipokerface.netty.transaction.ResponseInboundHandlerAdapter;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
extends NettyContext {
    private static final Logger logger = LoggerFactory.getLogger(NettyServer.class);
    protected int port;
    protected ServerBootstrap bootstrap;
    protected ConnectionManager connectionManager;

    public NettyServer() {
        this.connectionManager = new ConnectionManager(this);
        this.initialBootstrap();
    }

    protected NettyServer(boolean init) {
        this.connectionManager = new ConnectionManager(this);
        if (init) {
            this.initialBootstrap();
        }
    }

    public NettyServer(int protocol, int version) {
        this.protocol = protocol;
        this.version = version;
        this.connectionManager = new ConnectionManager(this);
        this.initialBootstrap();
    }

    public NettyServer(int protocol, int version, boolean socketKeepAlive, boolean tcpNoDelay) {
        this.protocol = protocol;
        this.version = version;
        this.socketKeepAlive = socketKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.connectionManager = new ConnectionManager(this);
        this.initialBootstrap();
    }

    public int getPort() {
        return this.port;
    }

    protected void initialBootstrap() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)this.socketKeepAlive)).option(ChannelOption.TCP_NODELAY, (Object)this.tcpNoDelay)).childHandler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

            protected void initChannel(NioSocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new ConnectionManagerInboundHandlerAdapter(NettyServer.this.connectionManager)});
                ch.pipeline().addLast(new ChannelHandler[]{new ProtocolInboundHandlerFrameDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new PacketInboundHandlerAdapter((NettyContext)NettyServer.this, NettyServer.this.decoder)});
                ch.pipeline().addLast(new ChannelHandler[]{new ResponseInboundHandlerAdapter((NettyContext)NettyServer.this, NettyServer.this.transactionManager)});
                ch.pipeline().addLast(new ChannelHandler[]{new RequestInboundHandlerAdapter((NettyContext)NettyServer.this, NettyServer.this.requestMappingManager)});
            }
        });
    }

    public void listen(int port) {
        this.port = port;
        this.bind(0);
    }

    protected void bind(final int retries) {
        this.bootstrap.bind(this.port).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) {
                if (future.isSuccess()) {
                    logger.info("Start NettyServer Success!! listened port [ " + NettyServer.this.port + " ]");
                } else if (retries > 2) {
                    logger.error("Start NettyServer failed after 3 times reties...!");
                } else {
                    NettyServer.this.bind(retries + 1);
                }
            }
        });
    }

    public void request(Connection connection, Request request) {
        this.request(connection, request, null);
    }

    public void request(Connection connection, Request request, ResponseListener responseListener) {
        if (connection == null) {
            return;
        }
        super.sendRequest(connection, request, responseListener);
    }

    public NettyServer setConnectionListener(ConnectionListener connectionListener) {
        this.connectionManager.setConnectionListener(connectionListener);
        return this;
    }

    public NettyServer registerHandler(String command, RequestHandler requestHandler) {
        super.registerRequestHandler(command, requestHandler);
        return this;
    }

    public NettyServer registerInterceptor(BeforeHandlerInterceptor beforeHandlerInterceptor) {
        super.registerRequestInterceptor(beforeHandlerInterceptor);
        return this;
    }

    public NettyServer registerInterceptor(AfterHandlerInterceptor afterHandlerInterceptor) {
        super.registerRequestInterceptor(afterHandlerInterceptor);
        return this;
    }

    public Connection getConnection(ChannelHandlerContext context) {
        return this.connectionManager.getConnection(context);
    }
}

