package cn.ipokerface.netty.client.connection;

import cn.ipokerface.netty.client.NettyClient;
import cn.ipokerface.netty.connection.Connection;
import io.netty.channel.ChannelHandlerContext;

/**
 * Created by       PokerFace
 * Create Date      2020-08-12.
 * Email:
 * Version          1.0.0
 * <p>
 * Description:
 */
public class ConnectionManager implements cn.ipokerface.netty.connection.ConnectionManager {

    private NettyClient context;
    private ClientConnection connection;
    private ConnectionListener connectionListener;


    public ConnectionManager(NettyClient context) {
        this.context = context;
        this.connection = new ClientConnection(context);
    }


    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public ClientConnection getConnection() {
        return connection;
    }

    public void connecting(String server, int port) {
        this.connection.host = server;
        this.connection.port = port;
        this.connection.state = ClientConnection.ConnectionState.CONNECTING;
    }

    public void connected(ChannelHandlerContext context) {
        connection.setChannelHandlerContext(context);
        connection.state = ClientConnection.ConnectionState.CONNECTED;
        if (connectionListener != null) {
            connectionListener.connected(this.connection);
        }
    }

    @Override
    public void connectionDisturbed(Connection connection) {
        disconnected(null);
    }

    public void disconnected(ChannelHandlerContext ctx) {
        connection.state = ClientConnection.ConnectionState.DISCONNECT;
        if (connectionListener != null) {
            connectionListener.disconnected(this.connection);
        }
    }


    public void connectFailed() {
        connection.state = ClientConnection.ConnectionState.DISCONNECT;
        if (connectionListener != null) {
            connectionListener.failed(this.connection);
        }
    }


}
